/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.agentapi;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.util.Id;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstanceService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.security.FMAgentAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AgentAPIController
extends PublicAPIControllerBase {
    @Autowired
    private FMAgentAuthService agentAuthService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private PhysicalInstanceProvisioningService provisionService;
    @Autowired
    private InstanceAgentActionsQueueService queueService;
    @Autowired
    private InstanceSettingsTemplateCRUDService instanceSettingsTemplateCRUDService;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstanceService instanceService;

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/actions/register-instance-secrets"})
    public void registerInstanceSecrets(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.instanceService.registerInstanceSecrets(tenantId, instanceId, (InstanceSecrets)this.getRequestBodyAs(req, InstanceSecrets.class));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/pending-commands/next"})
    public void getNextPendingCommand(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)this.queueService.waitForCommand(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/pending-commands/{commandId}/progress"})
    public void updateRunningCommandProgress(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @PathVariable String commandId) throws Exception {
        FutureResponse fr = (FutureResponse)this.getRequestBodyAs(req, FutureResponse.class);
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.queueService.updateState(tenantId, instanceId, commandId, (FutureResponse<JsonObject>)fr);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/pending-commands/{commandId}/complete"})
    public void setCommandComplete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @PathVariable String commandId) throws Exception {
        CommandResult cr;
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        try {
            cr = (CommandResult)this.getRequestBodyAs(req, CommandResult.class);
        }
        catch (DKUControllerBase.MalformedRequestException e) {
            logger.error((Object)"The request body could not be deserialized as a CommandResult", (Throwable)e);
            cr = new CommandResult();
            cr.outcome = InstanceAgentActionsQueueService.CommandState.FAILED;
            cr.error = new SerializedError((Throwable)e, true);
            cr.result = new JsonObject();
        }
        this.queueService.acknowledgeCommandCompletion(tenantId, instanceId, commandId, cr);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/actions/heartbeat"})
    public void heartbeat(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        HeartbeatState hs = (HeartbeatState)this.getRequestBodyAs(req, HeartbeatState.class);
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.instanceService.onHeartbeatReceived(tenantId, instanceId, hs);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/actions/save-agent-logs"})
    public void saveAgentLogs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.instancesCRUDService.saveAgentLogs(tenantId, instanceId, (InputStream)req.getInputStream());
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/expanded-settings"})
    public void getExpandedInstanceSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)this.instancesCRUDService.getExpandedInstanceSettings(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/ssl-certificate-key"})
    public void getSSLCertificateKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)new Id(this.instancesCRUDService.getSSLCertificateKey(tenantId, instanceId)));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/ssh-private-key/{alias}"})
    public void getSSHPrivateKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @PathVariable String alias) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", tenantId);
        InstanceSettingsTemplateDTO instanceSettingsTemplate = this.instanceSettingsTemplateCRUDService.get(tenantId, this.instanceService.get((String)tenantId, (String)instanceId).instanceSettingsTemplateId);
        String privateKey = instanceSettingsTemplate.setupActions.stream().filter(s -> s.type == SetupAction.SetupActionType.ADD_SSH_KEY).filter(s -> alias.equals(s.params.get("alias").getAsString())).findFirst().map(s -> this.cryptoService.decrypt(tenant, s.params.get("privateKey").getAsString())).orElseThrow(() -> new IllegalArgumentException("Alias '" + alias + "' doesn't exist for instance  '" + instanceId + "'"));
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)new Id(privateKey));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/license"})
    public void getLicense(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)this.instancesCRUDService.getLicense(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/dataiku-aws-keypair"})
    public void getDataikuAWSKeypair(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)this.instancesCRUDService.getDataikuAwsKeypair(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/nodes-directory"})
    public void getNodesDirectory(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)this.instanceService.getNodesDirectory(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/events/agent-alive"})
    public void onAgentAlive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.provisionService.onAgentAlive(tenantId, instanceId);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/events/initialization-startup"})
    public void onInitializationStartup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.provisionService.onInitializationStartup(tenantId, instanceId);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/events/initialization-complete"})
    public void onInitializationComplete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.provisionService.onInitializationComplete(tenantId, instanceId);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/events/startup-complete"})
    public void onStartupComplete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        this.provisionService.onStartupComplete(tenantId, instanceId);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/events/startup-failed"})
    public void onStartupFailed(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        SerializedError se = (SerializedError)this.getRequestBodyAs(req, SerializedError.class);
        this.provisionService.onStartupFailed(tenantId, instanceId, se);
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/agent-dev-bundle-hash"})
    public void getAgentDevBundleHash(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        AgentAPIController.writeJSON((HttpServletResponse)resp, (Object)FMApp.getDevAgentCode());
    }

    @RequestMapping(value={"/api/agent/tenants/{tenantId}/instances/{instanceId}/agent-dev-bundle"})
    public void getAgentDevBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        this.agentAuthService.verifyAgentAuth(tenantId, instanceId, req);
        String hash = (String)this.getRequestBodyAs(req, String.class);
        FMApp.streamDevAgentCode(hash, resp);
    }

    public static class InstanceSecrets {
        public String adminPassword;
        public String adminAPIKey;
    }

    public static class CommandResult {
        public InstanceAgentActionsQueueService.CommandState outcome;
        public SerializedError error;
        public JsonObject result;
    }

    public static class HeartbeatState {
        public HeartbeatHealthState state;
        public SerializedError error;
        public long bytesUsed;
        public long bytesTotal;
        public long deviceSize;
        public Long osBytesUsed;
        public Long osBytesTotal;
        public Long osDeviceSize;
    }

    public static enum HeartbeatHealthState {
        HEALTHY,
        UNHEALTHY,
        WARNING;

    }
}

