/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.server.alerts.checkers.Checker;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceDataDiskConsumptionV1Checker;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceInvalidStatusV1Checker;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceOSDiskConsumptionV1Checker;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CheckDefinitionService {
    Map<CheckKey, Checker> checkerMap = CheckDefinitionService.buildMapKeyedByCheckKey(Set.of(new LogicalInstanceOSDiskConsumptionV1Checker(), new LogicalInstanceDataDiskConsumptionV1Checker(), new LogicalInstanceInvalidStatusV1Checker()));

    public Checker getChecker(CheckType checkType, int configurationVersion) {
        return this.checkerMap.get(new CheckKey(checkType, configurationVersion));
    }

    private static Map<CheckKey, Checker> buildMapKeyedByCheckKey(Set<Checker> checksSet) {
        return checksSet.stream().collect(Collectors.toMap(check -> new CheckKey(check.getCheckType(), check.getVersion()), Function.identity()));
    }

    record CheckKey(CheckType checkType, int integer) {
    }
}

