/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.license.LicenseFetcher;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.settings.SettingsDAO;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class LicenseSyncService {
    @Autowired
    private SettingsDAO settingsDAO;
    @Autowired
    private DatabaseAccessService dbService;
    public static final long INITIAL_DELAY_MS = FMApp.getParams().getLongParam("dku.fm.licenses.initialFetchDelayS", 20L) * 1000L;
    private static final long REFRESH_INTERVAL_MS = FMApp.getParams().getLongParam("dku.fm.licenses.refreshIntervalS", 3600L) * 1000L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.license");

    @PostConstruct
    public void start() throws IOException {
        new LicenseRefreshThread().start();
    }

    public void forceImmediateRefresh(String tenantId) throws IOException {
        this.fetchAndUpdateForTenant(tenantId);
    }

    private void fetchAndUpdateForTenant(String tenantId) throws IOException {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        new LicenseFetcher().fetchAndSaveForTenant(tenant);
    }

    private class LicenseRefreshThread
    extends Thread {
        private LicenseRefreshThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(INITIAL_DELAY_MS);
                while (true) {
                    try {
                        while (true) {
                            List<Tenant> tenants = LicenseSyncService.this.dbService.listResults(Tenant.class, "SELECT t FROM tenant t", new Object[0]);
                            for (Tenant tenant : tenants) {
                                logger.info((Object)("will refresh licenses for tenant " + tenant.getId()));
                                if (tenant.getLicenseMode() != Tenant.LicenseMode.AUTO_UPDATE) continue;
                                try {
                                    LicenseSyncService.this.fetchAndUpdateForTenant(tenant.getId());
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Failed to refresh license for tenant " + tenant.getId()), (Throwable)e);
                                }
                            }
                            Thread.sleep(REFRESH_INTERVAL_MS);
                        }
                    }
                    catch (Throwable t) {
                        logger.warn((Object)"License refresh failed", t);
                        Thread.sleep(REFRESH_INTERVAL_MS);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"License refresh thread was interrupted", (Throwable)e);
                return;
            }
        }
    }
}

