/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.com.google.common.base.Charsets;
import com.dataiku.fm.cloud.CloudInstanceService;
import com.dataiku.fm.cloud.VolumeNotFoundException;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.license.MinimalDSSLicenseParser;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalInstanceEvent;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.DataVolumeSnapshotDTO;
import com.dataiku.fm.model.published.DeleteLogicalInstanceResult;
import com.dataiku.fm.model.published.DeleteSnapshotResult;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.alerts.CheckDefinitionCRUDService;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.instances.NodesDirectoryUpdateService;
import com.dataiku.fm.server.loadbalancers.LoadBalancerService;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import com.dataiku.fm.server.snapshots.SnapshotsCRUDService;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhysicalInstanceProvisioningService {
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudInstanceService cloudInstanceService;
    @Autowired
    private InstanceAgentActionsQueueService actionsQueueService;
    @Autowired
    private InstancesCRUDService instancesService;
    @Autowired
    private InstancesEventLogService eventsLogService;
    @Autowired
    private NodesDirectoryUpdateService nodesDirectoryUpdateService;
    @Autowired
    private LoadBalancerService loadBalancerService;
    @Autowired
    private LoadBalancersCRUDService loadBalancersCRUDService;
    @Autowired
    private CheckDefinitionCRUDService checkDefinitionCRUDService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.instances");

    public PublicPhysicalInstanceStatus getStatus(String tenantId, String instanceId) {
        PublicPhysicalInstanceStatus ret = new PublicPhysicalInstanceStatus();
        LogicalInstance li = InstancesHelper.getInstance(this.dbService, tenantId, instanceId);
        if (li == null) {
            logger.warnV("Cannot retrieve physical instance status, because instance does not exist: tenantId=%s, instanceId=%s", new Object[]{tenantId, instanceId});
            ret.statusMessages.withFatal((InfoMessage.MessageCode)FMServerCodes.ERR_INVALID_INSTANCE_NOT_DEPLOYED, "Unknown instance");
            return ret;
        }
        ret.logicalInstanceExists = true;
        ret.logicalInstanceLabel = li.getLabel();
        ret.instanceSettingsTemplateId = li.getInstanceSettingsTemplate().getId();
        ret.instanceSettingsTemplateLabel = li.getInstanceSettingsTemplate().getLabel();
        ret.virtualNetworkLabel = li.getVirtualNetwork().getLabel();
        ret.dataVolumeSizeGB = li.getDataVolumeSizeGB();
        ret.dataVolumeSizeMaxGB = li.getDataVolumeSizeMaxGB();
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            logger.warn((Object)"Did not currently have an associated PhysicalInstance");
            ret.statusMessages.withFatal((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "No physical instance");
            return ret;
        }
        ret.hasPhysicalInstance = true;
        ret.imageId = pi.getCreationState().getImageId();
        ret.stage = InstancesHelper.computeLifeCycleStage(pi);
        ret.lastHeartbeatState = pi.getLastHeartbeatState() == null ? null : (AgentAPIController.HeartbeatState)JSON.parse((String)pi.getLastHeartbeatState(), AgentAPIController.HeartbeatState.class);
        ret.lastHeartbeatTimestamp = pi.getLastHeartbeatTimestamp();
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        this.cloudInstanceService.fillPhysicalStatusWithCloudSpecificData(pi, pdv, ret);
        return ret;
    }

    public FutureResponse<PublicPhysicalInstanceStatus> startReprovision(FMAuthCtx authCtx, String instanceId) throws Exception {
        InstancesCRUDService.InstanceLicense license = this.instancesService.getLicense(authCtx.getTenantId(), instanceId);
        if (license.hasLicense) {
            logger.info((Object)"Instance has a license, performing limit checks");
            Map<String, Set<String>> idsByNodeType = this.instancesService.listInternal(authCtx.getTenantId()).stream().filter(li -> li.getCurrentPhysicalInstance() != null && li.getDssNodeType() != null).collect(Collectors.groupingBy(LogicalInstance::getDssNodeType, Collectors.mapping(LogicalInstance::getId, Collectors.toSet())));
            logger.info((Object)("Currently provisioned :" + idsByNodeType.entrySet().stream().map(e -> String.format("%s=%d", e.getKey(), ((Set)e.getValue()).size())).collect(Collectors.joining(", "))));
            LogicalInstance instanceToProvision = this.instancesService.getInternal(authCtx.getTenantId(), instanceId);
            idsByNodeType.computeIfAbsent((String)StringUtils.defaultIfBlank((CharSequence)instanceToProvision.getDssNodeType(), (CharSequence)""), t -> new HashSet()).add(instanceToProvision.getId());
            License licenseObj = (License)JSON.parse((String)license.license, License.class);
            MinimalDSSLicenseParser.FMLicenseFeaturesStatus status = MinimalDSSLicenseParser.parse(licenseObj);
            logger.info((Object)("License status: " + JSON.json((Object)status)));
            this.checkInstanceTypeLimit(status.fmMaxDesignNodes, "design", idsByNodeType);
            this.checkInstanceTypeLimit(status.fmMaxAutomationNodes, "automation", idsByNodeType);
            this.checkInstanceTypeLimit(status.fmMaxDeployerNodes, "deployer", idsByNodeType);
        }
        return this.futureService.runFuture(new InstanceReprovisionFutureThread(authCtx, "reprovision", instanceId), 0L, (TypeToken)new TypeToken<FutureResponse<PublicPhysicalInstanceStatus>>(){});
    }

    private void checkInstanceTypeLimit(Integer maxInstances, String nodeType, Map<String, Set<String>> idsByNodeType) throws LicenseRestrictionException {
        int nbProvisioned = ((Set)idsByNodeType.getOrDefault(nodeType, new HashSet())).size();
        if (maxInstances != null && maxInstances >= 0 && nbProvisioned > maxInstances) {
            throw new LicenseRestrictionException("You have exceeded your max of " + maxInstances + " deployed " + nodeType + " nodes");
        }
    }

    public FutureResponse<CommandResult> refreshLoadBalancer(FMAuthCtx authCtx, String instanceId) throws Exception {
        return this.futureService.runFuture(new InstanceFutureThread(authCtx, "delete", instanceId){

            @Override
            public CommandResult action(String tenantId, String instanceId, DKUtils.SmartLogTailBuilder smartLogTail) {
                PhysicalInstanceProvisioningService.this.loadBalancerService.onAfterInstanceStatusUpdate(tenantId, instanceId);
                return CommandResult.withSuccess(true);
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    private void waitStartupStages(String physicalInstanceId) throws Exception {
        double startingStateIndex = FutureProgress.getState().cur;
        FutureProgress.pushAutoCloseableState((String)"Waiting for agent to start up");
        PhysicalInstance.LifecycleStage current = PhysicalInstance.LifecycleStage.WAITING_AGENT;
        while (true) {
            PhysicalInstance pi = this.waitForStageChange(physicalInstanceId, current);
            current = pi.getLifecycleStage();
            switch (pi.getLifecycleStage()) {
                case WAITING_AGENT: {
                    throw new Error("bad state");
                }
                case INITIALIZING: {
                    FutureProgress.popState();
                    FutureProgress.updateState((double)(startingStateIndex + 1.0));
                    FutureProgress.pushAutoCloseableState((String)"Preparing instance");
                    break;
                }
                case DSS_STARTING_UP: {
                    FutureProgress.popState();
                    FutureProgress.updateState((double)(startingStateIndex + 2.0));
                    FutureProgress.pushAutoCloseableState((String)"Starting DSS");
                    break;
                }
                case FAILED: {
                    FutureProgress.popState();
                    throw new IllegalStateException("DSS startup failed. Check events for more information");
                }
                case RUNNING: {
                    FutureProgress.popState();
                    return;
                }
                case NOT_RESPONDING: {
                    FutureProgress.popState();
                    throw new IllegalStateException("DSS didn't respond. Check events for more information");
                }
            }
        }
    }

    public FutureResponse<PublicPhysicalInstanceStatus> startReprovisionFromPreviousSnapshot(FMAuthCtx authCtx, String instanceId, String snapshotId) throws Exception {
        return this.futureService.runFuture(new InstanceReprovisionFromPreviousSnapshotFutureThread(authCtx, "x", instanceId, snapshotId), 0L, (TypeToken)new TypeToken<FutureResponse<PublicPhysicalInstanceStatus>>(){});
    }

    public FutureResponse<PublicPhysicalInstanceStatus> startDeprovision(FMAuthCtx authCtx, String instanceId) throws Exception {
        return this.futureService.runFuture(new InstanceDeprovisionFutureThread(authCtx, instanceId), 0L, (TypeToken)new TypeToken<FutureResponse<PublicPhysicalInstanceStatus>>(){});
    }

    private void saveState(PhysicalInstance pi, PhysicalInstance.LifecycleStage stage) throws Exception {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLifecycleStage(stage);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
    }

    public FutureResponse<PublicPhysicalInstanceStatus> startPhysicalStart(FMAuthCtx authCtx, String instanceId) throws Exception {
        return this.futureService.runFuture(new InstanceStartFutureThread(authCtx, instanceId), 0L, (TypeToken)new TypeToken<FutureResponse<PublicPhysicalInstanceStatus>>(){});
    }

    public FutureResponse<PublicPhysicalInstanceStatus> startPhysicalStop(FMAuthCtx authCtx, String instanceId) throws Exception {
        return this.futureService.runFuture(new InstanceStopFutureThread(authCtx, instanceId), 0L, (TypeToken)new TypeToken<FutureResponse<PublicPhysicalInstanceStatus>>(){});
    }

    public FutureResponse<PublicPhysicalInstanceStatus> startPhysicalReboot(FMAuthCtx authCtx, String instanceId) throws Exception {
        return this.futureService.runFuture(new InstanceRebootFutureThread(authCtx, instanceId), 0L, (TypeToken)new TypeToken<FutureResponse<PublicPhysicalInstanceStatus>>(){});
    }

    public FutureResponse<DeleteLogicalInstanceResult> startDeleteInstance(FMAuthCtx authCtx, String instanceId) throws Exception {
        return this.futureService.runFuture(new InstanceDeleteFutureThread(authCtx, instanceId), 0L, (TypeToken)new TypeToken<FutureResponse<DeleteLogicalInstanceResult>>(){});
    }

    public DataVolumeSnapshotDTO snapshot(String tenantId, String instanceId, String reasonForSnapshot) {
        logger.infoV("Creating manual snapshot: tenantId=%s, liId=%s, reason=%s", new Object[]{tenantId, instanceId, reasonForSnapshot});
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        DataVolumeSnapshot dvs = this.cloudInstanceService.createPhysicalDataVolumeSnapshot(li, "manual", reasonForSnapshot);
        logger.infoV("Created manual snapshot: snapshotId=%s, awsSnapshotId=%s, azureSnapshotId=%s", new Object[]{dvs.getId(), dvs.getAwsSnapshotId(), dvs.getAzureSnapshotId()});
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstance physicalInstance = this.getPhysicalInstance(li);
            if (physicalInstance == null) {
                PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
                dvs.setCreationState(pics);
                rwt.getThreadEM().persist((Object)pics);
            } else {
                dvs.setCreationState(physicalInstance.getCreationState());
            }
            rwt.getThreadEM().persist((Object)dvs);
            rwt.commit();
        }
        return SnapshotsCRUDService.convertToDTO(dvs);
    }

    public FutureResponse<DeleteSnapshotResult> startDeleteSnapshot(FMAuthCtx authCtx, String instanceId, String snapshotId) throws Exception {
        return this.futureService.runFuture(new DeleteSnapshotFutureThread(authCtx, instanceId, snapshotId), 0L, (TypeToken)new TypeToken<FutureResponse<DeleteSnapshotResult>>(){});
    }

    public FutureResponse<DeleteSnapshotResult> startDeleteSnapshots(FMAuthCtx authCtx, String instanceId, List<String> snapshots) throws Exception {
        return this.futureService.runFuture(new DeleteSnapshotsFutureThread(authCtx, instanceId, snapshots), 0L, (TypeToken)new TypeToken<FutureResponse<DeleteSnapshotResult>>(){});
    }

    public DeleteSnapshotResult deleteSnapshot(String tenantId, String instanceId, String snapshotId) {
        return this.deleteSnapshot(tenantId, instanceId, snapshotId, null);
    }

    public DeleteSnapshotResult deleteSnapshot(String tenantId, String instanceId, String snapshotId, AtomicBoolean errorReported) {
        DeleteSnapshotResult result;
        block3: {
            logger.infoV("Deleting snapshot tenantId=%s liId=%s snapshotId=%s", new Object[]{tenantId, instanceId, snapshotId});
            DataVolumeSnapshot snapshot = (DataVolumeSnapshot)this.dbService.getThreadEM().find(DataVolumeSnapshot.class, (Object)snapshotId);
            if (snapshot == null) {
                throw new IllegalArgumentException("Unable to delete snapshot " + snapshotId + " because it does not exist.");
            }
            result = new DeleteSnapshotResult();
            LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
            logger.infoV("Deleting Data volume snapshot %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(snapshot)});
            try {
                this.cloudInstanceService.deletePhysicalDataVolumeSnapshot(snapshot, li);
                this.removeSnapshotAndConditionallyRemoveCreationState(snapshot, li);
                result.success = true;
            }
            catch (RuntimeException e) {
                logger.warnV((Throwable)e, "Unable to delete data volume snapshot %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(snapshot)});
                result.statusMessages.withWarning((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, "Snapshot " + PhysicalInstanceProvisioningService.cloudId(snapshot) + " deletion failure: " + e.getMessage());
                if (errorReported == null) break block3;
                errorReported.set(true);
            }
        }
        return result;
    }

    private void removeSnapshotAndConditionallyRemoveCreationState(DataVolumeSnapshot snapshot, LogicalInstance li) {
        PhysicalInstanceCreationState creationState = snapshot.getCreationState();
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstance pi = this.getPhysicalInstance(li);
            if (!(pi != null && PhysicalInstanceProvisioningService.sameCreationState(creationState, pi.getCreationState()) || this.countSnapshotsUsingCreationState(li, creationState) != 1)) {
                this.deleteCreationState(rwt, creationState);
            }
            rwt.getThreadEM().remove((Object)snapshot);
            rwt.commit();
        }
    }

    private int countSnapshotsUsingCreationState(LogicalInstance li, PhysicalInstanceCreationState creationState) {
        logger.debugV("Counting number of snapshots using PhysicalInstanceCreationState %d", new Object[]{creationState.getId()});
        List<DataVolumeSnapshot> snapshotsUsingCreationState = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs WHERE dvs.logicalInstance=?1 and creationState=?2", li, creationState);
        int result = snapshotsUsingCreationState.size();
        logger.debugV("=> %d snapshots", new Object[]{result});
        return result;
    }

    private DeleteLogicalInstanceResult deleteInstance(String tenantId, String instanceId) {
        DeleteLogicalInstanceResult result = new DeleteLogicalInstanceResult();
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi != null) {
            throw new IllegalStateException("Instance is currently provisioned. Deprovision it first to delete it.");
        }
        this.loadBalancersCRUDService.getLoadBalancer(li.getId()).ifPresent(loadBalancer -> {
            try (FutureProgress.AutocloseableFutureProgressState updateLb = FutureProgress.pushAutoCloseableState((String)"Update load-balancer", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                 DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                this.loadBalancerService.deleteLoadBalancerDependencies(rwt, li);
                rwt.commit();
            }
        });
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Deleting instance", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                this.deleteVolumeSnapshotsIgnoringFailures(rwt, li, result);
                rwt.commit();
            }
            rwt = this.dbService.rwTransaction();
            try {
                this.deleteVolumes(rwt, li, result);
                this.deleteEvents(rwt, li);
                rwt.getThreadEM().remove(rwt.getThreadEM().getReference(LogicalInstance.class, (Object)li.getId()));
                rwt.commit();
            }
            finally {
                if (rwt != null) {
                    rwt.close();
                }
            }
        }
        result.success = true;
        return result;
    }

    private void deleteCreationState(DatabaseAccessService.ReadWriteTransaction rwt, PhysicalInstanceCreationState creationState) {
        InstanceSettingsTemplate instanceSettingsTemplate = creationState.getInstanceSettingsTemplate();
        if (instanceSettingsTemplate.isForSnapshot() || instanceSettingsTemplate.getId().startsWith("ist-snap-")) {
            rwt.getThreadEM().remove((Object)instanceSettingsTemplate);
        }
        rwt.getThreadEM().remove((Object)creationState);
    }

    private void deleteVolumeSnapshotsIgnoringFailures(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, DeleteLogicalInstanceResult result) {
        List<DataVolumeSnapshot> snapshots = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1", li);
        for (DataVolumeSnapshot snapshot : snapshots) {
            logger.infoV("Deleting Data volume snapshot %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(snapshot)});
            try {
                this.cloudInstanceService.deletePhysicalDataVolumeSnapshot(snapshot, li);
            }
            catch (RuntimeException e) {
                logger.warnV((Throwable)e, "Unable to delete data volume snapshot %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(snapshot)});
                result.statusMessages.withWarning((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, e.getMessage());
            }
            this.deleteCreationState(rwt, snapshot.getCreationState());
            rwt.getThreadEM().remove((Object)snapshot);
        }
    }

    private void detachVolume(DatabaseAccessService.ReadWriteTransaction rwt, PhysicalDataVolume volume) {
        PhysicalInstanceCreationState creationState = volume.getCreationState();
        if (creationState != null) {
            this.deleteCreationState(rwt, creationState);
            volume.setCreationState(null);
        }
        volume.setDetached(true);
        rwt.getThreadEM().persist((Object)volume);
    }

    private void removeVolumeFromDB(DatabaseAccessService.ReadWriteTransaction rwt, PhysicalDataVolume volume) {
        PhysicalInstanceCreationState creationState = volume.getCreationState();
        if (creationState != null) {
            this.deleteCreationState(rwt, creationState);
        }
        rwt.getThreadEM().remove((Object)volume);
    }

    private void deleteVolumes(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, DeleteLogicalInstanceResult result) {
        List<PhysicalDataVolume> volumes = this.dbService.listResults(PhysicalDataVolume.class, "SELECT dv from physicaldatavolume dv where dv.logicalInstance=?1", li);
        for (PhysicalDataVolume volume : volumes) {
            logger.infoV("Deleting Data volume %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(volume)});
            try {
                this.cloudInstanceService.deletePhysicalDataVolume(volume, li);
            }
            catch (RuntimeException e) {
                logger.warnV((Throwable)e, "Unable to delete data volume %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(volume)});
                result.statusMessages.withWarning((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, e.getMessage());
            }
            this.removeVolumeFromDB(rwt, volume);
        }
    }

    private void deleteEvents(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        List<LogicalInstanceEvent> events = this.dbService.listResults(LogicalInstanceEvent.class, "SELECT lie from logicalinstanceevent lie where lie.logicalInstance=?1", li);
        for (LogicalInstanceEvent event : events) {
            rwt.getThreadEM().remove((Object)event);
        }
    }

    /*
     * Exception decompiling
     */
    private void deprovision(String tenantId, String instanceId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void terminatePreviousPhysicalInstance(LogicalInstance li, String reasonForSnapshot) {
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            logger.warn((Object)"Did not currently have an associated PhysicalInstance");
        } else {
            this.eventsLogService.addEventASync_NT(li, null, "pi-unprovision-start", this.getEventObj(pi));
            try {
                this.cloudInstanceService.terminatePhysicalInstance(pi);
                this.eventsLogService.addEventASync_NT(li, null, "pi-unprovision-done", this.getEventObj(pi));
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to terminate previous physical instance, ignoring", (Throwable)e);
                this.eventsLogService.addEventASync_NT(li, null, "pi-unprovision-failed", this.getEventObj(pi));
            }
            PhysicalInstanceCreationState pics = pi.getCreationState();
            String tenantId = li.getTenant().getId();
            String vnId = li.getVirtualNetwork().getId();
            String liId = li.getId();
            DataVolumeSnapshot dvs = null;
            try {
                dvs = this.cloudInstanceService.createPhysicalDataVolumeSnapshot(li, "automatic", reasonForSnapshot);
            }
            catch (VolumeNotFoundException e) {
                logger.warn((Object)String.format("Failed to take a snapshot of instance %s, ignoring.", liId), (Throwable)e);
            }
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                if (dvs != null) {
                    dvs.setCreationState(pics);
                    rwt.getThreadEM().persist((Object)dvs);
                    this.eventsLogService.addEventASync_NT(li, null, "li-snapshot-created", this.getEventObj(dvs).with("cloudInstanceType", pics.getCloudInstanceType()).with("imageId", pics.getImageId()));
                } else {
                    logger.warn((Object)String.format("Snapshot for logical instance '%s' was not created, not persisting it to the database.", liId));
                }
                li.setCurrentPhysicalInstance(null);
                rwt.getThreadEM().persist((Object)li);
                rwt.getThreadEM().remove((Object)pi);
                rwt.commit();
            }
            this.nodesDirectoryUpdateService.onAfterInstanceStatusUpdate(tenantId, vnId, liId, "unprovisioned");
        }
    }

    public void onAgentAlive(String tenantId, String instanceId) {
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            throw new IllegalStateException(String.format("Received agent message for instance id=%s, tenantId=%s but there is no provisioned physical instance.", tenantId, instanceId));
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLifecycleStage(PhysicalInstance.LifecycleStage.INITIALIZING);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        this.eventsLogService.addEventASync_NT(li, null, "pi-agent-alive", this.getEventObj(pi));
    }

    public void onInitializationStartup(String tenantId, String instanceId) {
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            throw new IllegalStateException(String.format("Received agent message for instance id=%s, tenantId=%s but there is no provisioned physical instance.", tenantId, instanceId));
        }
        this.cloudInstanceService.configurePhysicalInstanceBeforeStartupPhase(pi);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLifecycleStage(PhysicalInstance.LifecycleStage.INITIALIZING);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        this.eventsLogService.addEventASync_NT(li, null, "pi-initialization-startup", this.getEventObj(pi));
    }

    public void onInitializationComplete(String tenantId, String instanceId) {
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            throw new IllegalStateException(String.format("Received agent message for instance id=%s, tenantId=%s but there is no provisioned physical instance.", tenantId, instanceId));
        }
        this.cloudInstanceService.configurePhysicalInstanceAfterStartupPhase(pi);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLifecycleStage(PhysicalInstance.LifecycleStage.DSS_STARTING_UP);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        this.eventsLogService.addEventASync_NT(li, null, "pi-initialization-complete", this.getEventObj(pi));
    }

    public void onStartupComplete(String tenantId, String instanceId) {
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            throw new IllegalStateException(String.format("Received agent message for instance id=%s, tenantId=%s but there is no provisioned physical instance.", tenantId, instanceId));
        }
        if (pi.getLifecycleStage() != PhysicalInstance.LifecycleStage.DSS_STARTING_UP) {
            throw new IllegalStateException("Bad lifecycle stage, got " + String.valueOf((Object)pi.getLifecycleStage()));
        }
        String virtualNetworkId = li.getVirtualNetwork().getId();
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLifecycleStage(PhysicalInstance.LifecycleStage.RUNNING);
            pi.setLastHeartbeatTimestamp(System.currentTimeMillis());
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        this.nodesDirectoryUpdateService.onAfterInstanceStatusUpdate(tenantId, virtualNetworkId, instanceId, "provisioned");
        this.checkDefinitionCRUDService.onAfterInstanceProvision(tenantId, li.getId());
        this.eventsLogService.addEventASync_NT(li, null, "pi-service-open", this.getEventObj(pi));
    }

    public void onStartupFailed(String tenantId, String instanceId, SerializedError se) {
        LogicalInstance li = this.getInstanceMandatory(tenantId, instanceId);
        PhysicalInstance pi = this.getPhysicalInstance(li);
        if (pi == null) {
            throw new IllegalStateException(String.format("Received agent message for instance id=%s, tenantId=%s but there is no provisioned physical instance.", tenantId, instanceId));
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLifecycleStage(PhysicalInstance.LifecycleStage.FAILED);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        this.eventsLogService.addEventASync_NT(li, null, "pi-initialization-failed", this.getEventObj(pi).withJSON("error", (Object)se));
    }

    private PhysicalInstance waitForStageChange(String physicalInstanceId, PhysicalInstance.LifecycleStage previousStage) throws InterruptedException {
        logger.infoV("Waiting for physical instance %s to transition from stage %s", new Object[]{physicalInstanceId, previousStage});
        while (true) {
            PhysicalInstance pi;
            if ((pi = this.dbService.getSingleResult(PhysicalInstance.class, "SELECT pi from physicalinstance pi where pi.id=?1", physicalInstanceId)) == null) {
                throw new IllegalStateException("Cannot wait for PhysicalInstance stage change: no PhysicalInstance");
            }
            if (pi.getLifecycleStage() != previousStage) {
                logger.debugV("Physical instance %s has transitioned to stage: %s", new Object[]{physicalInstanceId, pi.getLifecycleStage()});
                return pi;
            }
            logger.debugV("Physical instance %s is still at stage: %s", new Object[]{physicalInstanceId, pi.getLifecycleStage()});
            Thread.sleep(2000L);
            this.dbService.getThreadEM().clear();
        }
    }

    public FutureResponse<JsonObject> startDSSRestart(FMAuthCtx authCtx, String instanceId) throws Exception {
        PublicPhysicalInstanceStatus physicalInstanceStatus = this.getStatus(authCtx.getTenantId(), instanceId);
        if (!physicalInstanceStatus.hasPhysicalInstance || !physicalInstanceStatus.cloudMachineExists) {
            throw new IllegalStateException("Instance is not provisioned. Provision this instance to start DSS.");
        }
        if (!physicalInstanceStatus.cloudMachineIsUp) {
            throw new IllegalStateException("Instance is not running. Please wait or start it manually.");
        }
        PhysicalInstance.LifecycleStage stage = InstancesHelper.getLifeCycleStage(this.dbService, authCtx.getTenantId(), instanceId);
        InstancesHelper.assertInstanceRunning(stage);
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.RESTART_DSS;
        return this.actionsQueueService.enqueueAndStartWait(authCtx, instanceId, ac);
    }

    private JF.ObjectBuilder getEventObj(PhysicalInstance pi) {
        JF.ObjectBuilder ob = JF.obj().with("physicalInstanceId", pi.getId());
        switch (FMApp.getFMSettingsUnsafe().cloud) {
            case AWS: {
                ob.with("ec2InstanceId", pi.getAwsEC2InstanceId());
                break;
            }
            case AZURE: {
                ob.with("vmInstanceId", pi.getAzureVMInstanceId());
                break;
            }
            case GCP: {
                ob.with("gceInstanceId", pi.getGcpGCEInstanceId());
            }
        }
        return ob;
    }

    private JF.ObjectBuilder getEventObj(DataVolumeSnapshot dvs) {
        JF.ObjectBuilder ob = JF.obj().with("snapshotId", dvs.getId());
        switch (FMApp.getFMSettingsUnsafe().cloud) {
            case AWS: {
                ob.with("ec2SnapshotId", dvs.getAwsSnapshotId());
                break;
            }
            case AZURE: {
                ob.with("vmSnapshotId", dvs.getAzureSnapshotId());
                break;
            }
            case GCP: {
                ob.with("gceSnapshotId", dvs.getGcpSnapshotId());
            }
        }
        return ob;
    }

    private LogicalInstance getInstanceMandatory(String tenantId, String instanceId) {
        return InstancesHelper.getInstanceMandatory(this.dbService, tenantId, instanceId);
    }

    public PhysicalInstance getPhysicalInstance(LogicalInstance li) {
        return InstancesHelper.getPhysicalInstance(this.dbService, li);
    }

    private InstanceSettingsTemplate getInstanceSettingsTemplate(String istId) {
        if (istId == null || istId.length() == 0) {
            return null;
        }
        return (InstanceSettingsTemplate)this.dbService.getThreadEM().find(InstanceSettingsTemplate.class, (Object)istId);
    }

    private static String cloudId(PhysicalDataVolume volume) {
        Cloud cloud = FMApp.getFMSettingsUnsafe().cloud;
        switch (cloud) {
            case AWS: {
                return volume.getAwsEBSId();
            }
            case AZURE: {
                return volume.getAzureDiskId();
            }
            case GCP: {
                return volume.getGcpDiskId();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + cloud.toString());
    }

    private static String cloudId(DataVolumeSnapshot snapshot) {
        Cloud cloud = FMApp.getFMSettingsUnsafe().cloud;
        switch (cloud) {
            case AWS: {
                return snapshot.getAwsSnapshotId();
            }
            case AZURE: {
                return snapshot.getAzureSnapshotId();
            }
            case GCP: {
                return snapshot.getGcpSnapshotId();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + cloud.toString());
    }

    private static boolean sameCreationState(PhysicalInstanceCreationState state1, PhysicalInstanceCreationState state2) {
        return state1.getId() == state2.getId();
    }

    private static void validateLicense(LogicalInstance li) throws ApplicativeException {
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        String license = ist.getLicense();
        try {
            License lic = (License)JSON.parse((String)PhysicalInstanceProvisioningService.parseLicense(license), License.class);
            LicenseUtils.verify((License)lic);
        }
        catch (Exception e) {
            throw new ApplicativeException("Invalid license", String.format("The license provided in the Instance Template '%s' is invalid: %s", ist.getLabel(), e.getMessage()));
        }
    }

    private static String parseLicense(String license) throws ApplicativeException {
        if (StringUtils.isBlank((CharSequence)license)) {
            throw new ApplicativeException("Invalid license", "No license provided");
        }
        if ((license = license.trim()).contains("{")) {
            return license;
        }
        try {
            String l2 = new String(Base64.decodeBase64((String)license), Charsets.UTF_8);
            if (l2.contains("{")) {
                return l2;
            }
            throw new ApplicativeException("Invalid license", "It does not look like a valid DSS license");
        }
        catch (Exception e) {
            throw new ApplicativeException("Invalid license", "It does not look like a valid DSS license");
        }
    }

    private class InstanceReprovisionFutureThread
    extends SimpleFMFutureThread<PublicPhysicalInstanceStatus> {
        private final String instanceId;
        final DKUtils.SmartLogTailBuilder smartLogTail;

        public InstanceReprovisionFutureThread(FMAuthCtx owner, String prefix, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, prefix);
            this.smartLogTail = new DKUtils.SmartLogTailBuilder();
            this.instanceId = instanceId;
        }

        public SmartLogTail getLog() {
            return this.smartLogTail.get();
        }

        @Override
        protected PublicPhysicalInstanceStatus compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Provisioning instance", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                String physicalInstanceId;
                LogicalInstance li = PhysicalInstanceProvisioningService.this.getInstanceMandatory(this.tenantId, this.instanceId);
                try (FutureProgress.AutocloseableFutureProgressState s1 = FutureProgress.pushAutoCloseableState((String)"Terminating existing instance");){
                    PhysicalInstanceProvisioningService.this.terminatePreviousPhysicalInstance(li, "Before reprovision");
                }
                FutureProgress.updateState((double)1.0);
                try (FutureProgress.AutocloseableFutureProgressState s2 = FutureProgress.pushAutoCloseableState((String)"Starting up new instance");){
                    physicalInstanceId = PhysicalInstanceProvisioningService.this.cloudInstanceService.createPhysicalInstance(li, this.smartLogTail);
                }
                FutureProgress.updateState((double)2.0);
                PhysicalInstanceProvisioningService.this.waitStartupStages(physicalInstanceId);
                PhysicalInstanceProvisioningService.this.loadBalancerService.onAfterInstanceStatusUpdate(this.tenantId, this.instanceId);
                PublicPhysicalInstanceStatus publicPhysicalInstanceStatus = PhysicalInstanceProvisioningService.this.getStatus(this.tenantId, this.instanceId);
                return publicPhysicalInstanceStatus;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class InstanceReprovisionFromPreviousSnapshotFutureThread
    extends SimpleFMFutureThread<PublicPhysicalInstanceStatus> {
        private final String instanceId;
        private final String snapshotId;
        final DKUtils.SmartLogTailBuilder smartLogTail;

        public InstanceReprovisionFromPreviousSnapshotFutureThread(FMAuthCtx owner, String prefix, String instanceId, String snapshotId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, prefix);
            this.smartLogTail = new DKUtils.SmartLogTailBuilder();
            this.instanceId = instanceId;
            this.snapshotId = snapshotId;
        }

        public SmartLogTail getLog() {
            return this.smartLogTail.get();
        }

        @Override
        protected PublicPhysicalInstanceStatus compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Reprovisioning instance", (double)6.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                String physicalInstanceId;
                LogicalInstance li = PhysicalInstanceProvisioningService.this.getInstanceMandatory(this.tenantId, this.instanceId);
                try (FutureProgress.AutocloseableFutureProgressState s1 = FutureProgress.pushAutoCloseableState((String)"Terminating existing instance");){
                    PhysicalInstanceProvisioningService.this.terminatePreviousPhysicalInstance(li, "Before reprovision from snapshot");
                }
                try (FutureProgress.AutocloseableFutureProgressState s2 = FutureProgress.pushAutoCloseableState((String)"Creating data volume from snapshot");
                     DatabaseAccessService.ReadWriteTransaction rwt = PhysicalInstanceProvisioningService.this.dbService.rwTransaction();){
                    li = PhysicalInstanceProvisioningService.this.getInstanceMandatory(this.tenantId, this.instanceId);
                    PhysicalDataVolume existingPdv = InstancesHelper.getVolume(PhysicalInstanceProvisioningService.this.dbService, li);
                    if (existingPdv == null) {
                        logger.warn((Object)"Did not have a PhysicalDataVolume!?");
                    } else {
                        logger.infoV("Removing PhysicalDataVolume: ebs=%s azure=%s gcp=%s", new Object[]{existingPdv.getAwsEBSId(), existingPdv.getAzureDiskId(), existingPdv.getGcpDiskId()});
                        PhysicalInstanceProvisioningService.this.detachVolume(rwt, existingPdv);
                    }
                    DataVolumeSnapshot dvs = (DataVolumeSnapshot)PhysicalInstanceProvisioningService.this.dbService.getThreadEM().find(DataVolumeSnapshot.class, (Object)this.snapshotId);
                    logger.infoV("Reprovision from snapshot %s", new Object[]{PhysicalInstanceProvisioningService.cloudId(dvs)});
                    PhysicalInstanceProvisioningService.this.cloudInstanceService.createPhysicalDataVolumeFromSnapshot(rwt, li, this.snapshotId);
                    PhysicalInstanceCreationState pics = dvs.getCreationState();
                    InstanceSettingsTemplate istSnapshot = pics.getInstanceSettingsTemplate();
                    assert (istSnapshot.isForSnapshot());
                    assert (istSnapshot.getTenant() != null);
                    assert (li.getTenant().getId().equals(istSnapshot.getTenant().getId()));
                    if (!istSnapshot.sameAs(li.getInstanceSettingsTemplate())) {
                        InstanceSettingsTemplate newIST;
                        InstanceSettingsTemplate originalIst = PhysicalInstanceProvisioningService.this.getInstanceSettingsTemplate(istSnapshot.getCopiedFromId());
                        if (istSnapshot.sameAs(originalIst)) {
                            newIST = originalIst;
                        } else {
                            newIST = istSnapshot.copyWithoutId();
                            assert (newIST.getTenant() != null);
                            assert (newIST.getTenant().getId().equals(li.getTenant().getId()));
                            newIST.setId("ist-restore-from-" + istSnapshot.getId() + "-" + SecretKeyGenerator.generate((int)12));
                            newIST.setCopiedFromId(null);
                            newIST.setForSnapshot(false);
                            rwt.getThreadEM().persist((Object)newIST);
                        }
                        li.setInstanceSettingsTemplate(newIST);
                    }
                    li.setCloudInstanceType(pics.getCloudInstanceType());
                    li.setImageId(pics.getImageId());
                    rwt.getThreadEM().persist((Object)li);
                    rwt.commit();
                }
                FutureProgress.updateState((double)2.0);
                try (FutureProgress.AutocloseableFutureProgressState s3 = FutureProgress.pushAutoCloseableState((String)"Starting up new instance");){
                    physicalInstanceId = PhysicalInstanceProvisioningService.this.cloudInstanceService.createPhysicalInstance(li, this.smartLogTail);
                }
                FutureProgress.updateState((double)3.0);
                PhysicalInstanceProvisioningService.this.waitStartupStages(physicalInstanceId);
                PhysicalInstanceProvisioningService.this.loadBalancerService.onAfterInstanceStatusUpdate(this.tenantId, this.instanceId);
                PublicPhysicalInstanceStatus publicPhysicalInstanceStatus = PhysicalInstanceProvisioningService.this.getStatus(this.tenantId, this.instanceId);
                return publicPhysicalInstanceStatus;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class InstanceDeprovisionFutureThread
    extends SimpleFMFutureThread<PublicPhysicalInstanceStatus> {
        private final String instanceId;

        public InstanceDeprovisionFutureThread(FMAuthCtx owner, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "deprovision");
            this.instanceId = instanceId;
        }

        @Override
        protected PublicPhysicalInstanceStatus compute() {
            PhysicalInstanceProvisioningService.this.deprovision(this.tenantId, this.instanceId);
            return PhysicalInstanceProvisioningService.this.getStatus(this.tenantId, this.instanceId);
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class InstanceStartFutureThread
    extends SimpleFMFutureThread<PublicPhysicalInstanceStatus> {
        private final String instanceId;

        public InstanceStartFutureThread(FMAuthCtx owner, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "startPhysical");
            this.instanceId = instanceId;
        }

        @Override
        protected PublicPhysicalInstanceStatus compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Starting instance", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                LogicalInstance li = PhysicalInstanceProvisioningService.this.getInstanceMandatory(this.tenantId, this.instanceId);
                PhysicalInstance pi = PhysicalInstanceProvisioningService.this.getPhysicalInstance(li);
                if (pi == null) {
                    throw new IllegalStateException("Instance is currently not provisioned");
                }
                PhysicalInstanceProvisioningService.this.saveState(pi, PhysicalInstance.LifecycleStage.WAITING_AGENT);
                try {
                    PhysicalInstanceProvisioningService.this.cloudInstanceService.startPhysicalInstance(pi);
                }
                catch (Exception e) {
                    logger.error((Object)"Starting the physical instance failed", (Throwable)e);
                    throw e;
                }
                FutureProgress.updateState((double)1.0);
                PhysicalInstanceProvisioningService.this.waitStartupStages(pi.getId());
                PhysicalInstanceProvisioningService.this.nodesDirectoryUpdateService.onAfterInstanceStatusUpdate(this.tenantId, li.getVirtualNetwork().getId(), this.instanceId, "started");
                PhysicalInstanceProvisioningService.this.loadBalancerService.onAfterInstanceStatusUpdate(this.tenantId, this.instanceId);
                PublicPhysicalInstanceStatus publicPhysicalInstanceStatus = PhysicalInstanceProvisioningService.this.getStatus(this.tenantId, this.instanceId);
                return publicPhysicalInstanceStatus;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class InstanceStopFutureThread
    extends SimpleFMFutureThread<PublicPhysicalInstanceStatus> {
        private final String instanceId;

        public InstanceStopFutureThread(FMAuthCtx owner, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "stopPhysical");
            this.instanceId = instanceId;
        }

        @Override
        protected PublicPhysicalInstanceStatus compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Stopping instance", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                LogicalInstance li = PhysicalInstanceProvisioningService.this.getInstanceMandatory(this.tenantId, this.instanceId);
                PhysicalInstance pi = PhysicalInstanceProvisioningService.this.getPhysicalInstance(li);
                if (pi == null) {
                    throw new IllegalStateException("Instance is currently not provisioned");
                }
                try {
                    PhysicalInstanceProvisioningService.this.cloudInstanceService.stopPhysicalInstance(pi);
                }
                catch (Exception e) {
                    logger.error((Object)"Stopping the physical instance failed", (Throwable)e);
                    throw e;
                }
                PhysicalInstanceProvisioningService.this.saveState(pi, PhysicalInstance.LifecycleStage.WAITING_AGENT);
                PhysicalInstanceProvisioningService.this.nodesDirectoryUpdateService.onAfterInstanceStatusUpdate(this.tenantId, li.getVirtualNetwork().getId(), this.instanceId, "stopped");
                PublicPhysicalInstanceStatus publicPhysicalInstanceStatus = PhysicalInstanceProvisioningService.this.getStatus(this.tenantId, this.instanceId);
                return publicPhysicalInstanceStatus;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class InstanceRebootFutureThread
    extends SimpleFMFutureThread<PublicPhysicalInstanceStatus> {
        private final String instanceId;

        public InstanceRebootFutureThread(FMAuthCtx owner, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "rebootPhysical");
            this.instanceId = instanceId;
        }

        @Override
        protected PublicPhysicalInstanceStatus compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Rebooting instance", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                LogicalInstance li = PhysicalInstanceProvisioningService.this.getInstanceMandatory(this.tenantId, this.instanceId);
                PhysicalInstance pi = PhysicalInstanceProvisioningService.this.getPhysicalInstance(li);
                if (pi == null) {
                    throw new IllegalStateException("Instance is currently not provisioned");
                }
                try (DatabaseAccessService.ReadWriteTransaction rwt = PhysicalInstanceProvisioningService.this.dbService.rwTransaction();){
                    pi.setLifecycleStage(PhysicalInstance.LifecycleStage.WAITING_AGENT);
                    rwt.getThreadEM().persist((Object)pi);
                    rwt.commit();
                }
                try {
                    PhysicalInstanceProvisioningService.this.cloudInstanceService.rebootPhysicalInstance(pi);
                }
                catch (Exception e) {
                    logger.error((Object)"Rebooting the physical instance failed", (Throwable)e);
                    throw e;
                }
                FutureProgress.updateState((double)1.0);
                PhysicalInstanceProvisioningService.this.waitStartupStages(pi.getId());
                PhysicalInstanceProvisioningService.this.loadBalancerService.onAfterInstanceStatusUpdate(this.tenantId, this.instanceId);
                PublicPhysicalInstanceStatus publicPhysicalInstanceStatus = PhysicalInstanceProvisioningService.this.getStatus(this.tenantId, this.instanceId);
                return publicPhysicalInstanceStatus;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class InstanceDeleteFutureThread
    extends SimpleFMFutureThread<DeleteLogicalInstanceResult> {
        private final String instanceId;
        final DKUtils.SmartLogTailBuilder smartLogTail;

        public InstanceDeleteFutureThread(FMAuthCtx owner, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "delete");
            this.smartLogTail = new DKUtils.SmartLogTailBuilder();
            this.instanceId = instanceId;
        }

        @Override
        protected DeleteLogicalInstanceResult compute() {
            return PhysicalInstanceProvisioningService.this.deleteInstance(this.tenantId, this.instanceId);
        }

        public FuturePayload getPayload() {
            return null;
        }

        public SmartLogTail getLog() {
            return this.smartLogTail.get();
        }
    }

    private class DeleteSnapshotFutureThread
    extends SimpleFMFutureThread<DeleteSnapshotResult> {
        private final String instanceId;
        private final String snapshotId;

        public DeleteSnapshotFutureThread(FMAuthCtx owner, String instanceId, String snapshotId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "delete");
            this.instanceId = instanceId;
            this.snapshotId = snapshotId;
        }

        @Override
        protected DeleteSnapshotResult compute() throws InterruptedException {
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Deleting snapshot", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                DeleteSnapshotResult deleteSnapshotResult = PhysicalInstanceProvisioningService.this.deleteSnapshot(this.tenantId, this.instanceId, this.snapshotId);
                return deleteSnapshotResult;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private class DeleteSnapshotsFutureThread
    extends SimpleFMFutureThread<DeleteSnapshotResult> {
        private final String instanceId;
        private final List<String> snapshotIds;

        public DeleteSnapshotsFutureThread(FMAuthCtx owner, String instanceId, List<String> snapshotIds) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, "delete");
            this.instanceId = instanceId;
            this.snapshotIds = snapshotIds;
        }

        @Override
        protected DeleteSnapshotResult compute() throws InterruptedException {
            DeleteSnapshotResult results = new DeleteSnapshotResult();
            try (FutureProgress.AutocloseableFutureProgressState progress = FutureProgress.pushAutoCloseableState((String)"Deleting snapshots", (double)this.snapshotIds.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                for (String id : this.snapshotIds) {
                    AtomicBoolean reported = new AtomicBoolean(false);
                    try {
                        results.statusMessages.mergeFrom(PhysicalInstanceProvisioningService.this.deleteSnapshot((String)this.tenantId, (String)this.instanceId, (String)id, (AtomicBoolean)reported).statusMessages);
                        progress.increment(1.0);
                    }
                    catch (Exception exc) {
                        if (reported.get()) continue;
                        logger.error((Object)"Error during snapshot deletion", (Throwable)exc);
                        results.statusMessages.withWarning((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, exc.getMessage());
                    }
                }
                DeleteSnapshotResult deleteSnapshotResult = results;
                return deleteSnapshotResult;
            }
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    private abstract class InstanceFutureThread
    extends SimpleFMFutureThread<CommandResult> {
        private final String instanceId;
        private final String label;
        final DKUtils.SmartLogTailBuilder smartLogTail;

        public InstanceFutureThread(FMAuthCtx owner, String action, String instanceId) {
            super(PhysicalInstanceProvisioningService.this.dbService, owner, action);
            this.smartLogTail = new DKUtils.SmartLogTailBuilder();
            this.instanceId = instanceId;
            this.label = action + " load balancer";
        }

        @Override
        protected CommandResult compute() {
            try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)(this.label + " load balancer"), (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                CommandResult commandResult = this.action(this.tenantId, this.instanceId, this.smartLogTail);
                return commandResult;
            }
        }

        public abstract CommandResult action(String var1, String var2, DKUtils.SmartLogTailBuilder var3);

        public FuturePayload getPayload() {
            return null;
        }

        public SmartLogTail getLog() {
            return this.smartLogTail.get();
        }
    }
}

