/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.monitoring;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.Utils;
import com.dataiku.fm.server.alerts.ElementCheckService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class AlertingTask
implements Job {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.job.task");
    private static final int JOB_TIMEOUT_IN_MIN = 5;
    @Autowired
    private ElementCheckService elementCheckService;

    public AlertingTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public long getJobTimeoutInMs() {
        return Utils.convertMinutesInMilliseconds(5);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.info((Object)"Alerting job started");
        try {
            this.elementCheckService.performEnabledChecks();
            logger.info((Object)"Alerting job ran successfully");
        }
        catch (IllegalStateException | UnsupportedOperationException e) {
            logger.error((Object)"An unsupported operation has been attempted during this job execution:", (Throwable)e);
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

