/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPINetworksController
extends PublicAPIControllerBase {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private VirtualNetworksService virtualNetworksService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/virtual-networks"}, method={RequestMethod.GET})
    public void getVirtualNetworks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        PublicAPINetworksController.writeJSON((HttpServletResponse)resp, this.virtualNetworksService.list(tenant));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/virtual-networks"}, method={RequestMethod.POST})
    public void createVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @RequestParam(required=false, defaultValue="false") boolean useDefaultValues) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        ProtoVirtualNetworkDTO in = (ProtoVirtualNetworkDTO)this.getRequestBodyAs(req, ProtoVirtualNetworkDTO.class);
        if (useDefaultValues) {
            Cloud cloud = FMApp.getFMSettingsUnsafe().cloud;
            boolean needValues = false;
            switch (cloud) {
                case AWS: {
                    needValues = StringUtils.isBlank((String)in.awsVpcId) && StringUtils.isBlank((String)in.awsSubnetId);
                    break;
                }
                case AZURE: {
                    needValues = StringUtils.isBlank((String)in.azureVnId) && StringUtils.isBlank((String)in.azureSubnetId);
                    break;
                }
                case GCP: {
                    boolean bl = needValues = StringUtils.isBlank((String)in.gcpNetwork) && StringUtils.isBlank((String)in.gcpSubnetwork);
                }
            }
            if (needValues) {
                ProtoVirtualNetworkDTO defaultValues = this.virtualNetworksService.getDefaultCreationValues(tenant);
                in.awsVpcId = defaultValues.awsVpcId;
                in.awsSubnetId = defaultValues.awsSubnetId;
                in.azureVnId = defaultValues.azureVnId;
                in.azureSubnetId = defaultValues.azureSubnetId;
                in.gcpProjectId = defaultValues.gcpProjectId;
                in.gcpNetwork = defaultValues.gcpNetwork;
                in.gcpSubnetwork = defaultValues.gcpSubnetwork;
            }
        }
        PublicAPINetworksController.writeJSON((HttpServletResponse)resp, (Object)this.virtualNetworksService.createVirtualNetwork(tenantId, in, new DKUtils.SmartLogTailBuilder()));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/virtual-networks/{virtualNetworkId}"}, method={RequestMethod.GET})
    public void getVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String virtualNetworkId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)virtualNetworkId);
        if (vn == null) {
            throw new IllegalArgumentException("Virtual network does not exists. It may have been deleted.");
        }
        if (!vn.getTenant().getId().equals(tenantId)) {
            throw new UnauthorizedException("Forbidden", "forbidden");
        }
        PublicAPINetworksController.writeJSON((HttpServletResponse)resp, (Object)this.virtualNetworksService.getVirtualNetworkDTO(tenant, virtualNetworkId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/virtual-networks/{virtualNetworkId}"}, method={RequestMethod.PUT})
    public void saveVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String virtualNetworkId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetworkSettingsDTO dto = (VirtualNetworkSettingsDTO)this.getRequestBodyAs(req, VirtualNetworkSettingsDTO.class);
        this.virtualNetworksService.saveVirtualNetwork(authCtx, tenant, virtualNetworkId, dto);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/virtual-networks/{virtualNetworkId}"}, method={RequestMethod.DELETE})
    public void deleteVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String virtualNetworkId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)virtualNetworkId);
        if (!vn.getTenant().getId().equals(tenantId)) {
            throw new UnauthorizedException("Forbidden", "forbidden");
        }
        PublicAPINetworksController.writeJSON((HttpServletResponse)resp, this.virtualNetworksService.startDelete(authCtx, virtualNetworkId, true, true));
    }
}

