/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security.auth;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.azure.AzureADUserSupplier;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.services.PubSubService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMAzureADUserSupplier
extends AzureADUserSupplier {
    private ProxySettings proxySettings;

    @Autowired
    public FMAzureADUserSupplier(PasswordEncryptionService passwordEncryptionService, PubSubService pubSubService) {
        super(passwordEncryptionService);
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        this.azureADSettings = fmSettings.azureADSettings;
        this.proxySettings = fmSettings.proxySettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            this.azureADSettings = settings.azureADSettings;
            this.proxySettings = settings.proxySettings;
            this.onRefreshSettings();
        });
    }

    public FMAzureADUserSupplier(PasswordEncryptionService passwordEncryptionService, AzureADSettings azureADSettings) {
        super(passwordEncryptionService);
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        this.azureADSettings = azureADSettings;
        this.proxySettings = fmSettings.proxySettings;
    }

    public ProxySettings getProxySetting() {
        return this.proxySettings;
    }
}

