/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import com.dataiku.fm.server.db.DatabaseAccessService;

public class SimulatorUtils {
    public static void runInThread(Runnable runnable, DatabaseAccessService dbService) throws InterruptedException {
        IsolatedDBThread thread = new IsolatedDBThread(runnable, dbService);
        thread.start();
        thread.join();
    }

    public static class IsolatedDBThread
    extends Thread {
        private final DatabaseAccessService dbService;

        public IsolatedDBThread(Runnable runnable, DatabaseAccessService dbService) {
            super(runnable);
            this.dbService = dbService;
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                this.dbService.close();
            }
        }
    }
}

