/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.transactions.git;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.CommitQueuesManager;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.ICommitBehavior;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.git.jgit.SingleRepositoryGitManager;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FMTransactionProviderSettings
extends TransactionProvider.TransactionProviderSettings {
    public FMTransactionProviderSettings(boolean useMainExclusiveLock, boolean forceCacheV1, boolean gitSupport) {
        super(useMainExclusiveLock, forceCacheV1, gitSupport, FileContentCompressor.NOOP_COMPRESSOR, null);
    }

    public CommitQueuesManager buildCommitQueuesManager(File root) throws IOException {
        return new CommitQueuesManager((CommitQueuesManager.ICommitQueuesBehavior)new CommitQueuesManager.GlobalCommitQueuesBehavior((IGitManager)new SingleRepositoryGitManager(root){

            protected String getPath(String namespace) {
                return "";
            }
        }));
    }

    public ICommitBehavior buildCommitBehavior() {
        return new NoCommitBehavior();
    }

    public static class NoCommitBehavior
    implements ICommitBehavior {
        public void executeStartCommitTask() {
        }

        public List<? extends CommitDef> getCommitList(File root, AuthCtx user, String message, MinimalRWTransaction.TransactionGitCommitPolicy gitCommitPolicy, List<RelFile> changes) {
            return Lists.newArrayList((Object[])new CommitDef[]{new CommitDef(new GitModel.GitAuthor(user), message, changes)});
        }

        public void executeEndCommitTask(AuthCtx user, String message) {
        }
    }
}

