/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.api;

import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.util.DateUtils;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

@Immutable
public class ResolveClaimsVerifier
extends DefaultJWTClaimsVerifier {
    public ResolveClaimsVerifier() {
        super(null, new HashSet<String>(Arrays.asList("iss", "sub", "iat", "exp", "metadata")));
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext context) throws BadJWTException {
        super.verify(claimsSet, context);
        Date now = new Date();
        if (!DateUtils.isBefore(claimsSet.getIssueTime(), now, this.getMaxClockSkew())) {
            throw new BadJWTException("JWT issue time after current time");
        }
    }
}

