/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.Field;
import com.dataiku.dss.shadelib.org.apache.lucene.document.FieldType;
import com.dataiku.dss.shadelib.org.apache.lucene.document.SortedSetDocValuesRangeQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValuesType;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MultiTermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermInSetQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.util.Collection;

public class SortedDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedDocValuesField(String name, BytesRef bytes) {
        super(name, TYPE);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive);
    }

    public static Query newSlowExactQuery(String field, BytesRef value) {
        return SortedDocValuesField.newSlowRangeQuery(field, value, value, true, true);
    }

    @Deprecated(forRemoval=true, since="9.10")
    public static Query newSlowSetQuery(String field, BytesRef ... values2) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values2);
    }

    public static Query newSlowSetQuery(String field, Collection<BytesRef> values2) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values2);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED);
        TYPE.freeze();
    }
}

