/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.OrdinalMappingLeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.CodecReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DirectoryReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SlowCodecReaderWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import java.io.IOException;
import java.util.List;

public abstract class TaxonomyMergeUtils {
    private TaxonomyMergeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Directory srcIndexDir, Directory srcTaxoDir, DirectoryTaxonomyWriter.OrdinalMap map, IndexWriter destIndexWriter, DirectoryTaxonomyWriter destTaxoWriter, FacetsConfig srcConfig) throws IOException {
        destTaxoWriter.addTaxonomy(srcTaxoDir, map);
        int[] ordinalMap = map.getMap();
        try (DirectoryReader reader = DirectoryReader.open(srcIndexDir);){
            List<LeafReaderContext> leaves = reader.leaves();
            int numReaders = leaves.size();
            CodecReader[] wrappedLeaves = new CodecReader[numReaders];
            for (int i = 0; i < numReaders; ++i) {
                wrappedLeaves[i] = SlowCodecReaderWrapper.wrap(new OrdinalMappingLeafReader(leaves.get(i).reader(), ordinalMap, srcConfig));
            }
            destIndexWriter.addIndexes(wrappedLeaves);
            destTaxoWriter.commit();
            destIndexWriter.commit();
        }
    }
}

