/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.search.BulkScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;

final class ReqExclBulkScorer
extends BulkScorer {
    private final BulkScorer req;
    private final DocIdSetIterator excl;

    ReqExclBulkScorer(BulkScorer req, DocIdSetIterator excl) {
        this.req = req;
        this.excl = excl;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
        int upTo = min2;
        int exclDoc = this.excl.docID();
        while (upTo < max) {
            if (exclDoc < upTo) {
                exclDoc = this.excl.advance(upTo);
            }
            if (exclDoc == upTo) {
                ++upTo;
                exclDoc = this.excl.nextDoc();
                continue;
            }
            upTo = this.req.score(collector, acceptDocs, upTo, Math.min(exclDoc, max));
        }
        if (upTo == max) {
            upTo = this.req.score(collector, acceptDocs, upTo, upTo);
        }
        return upTo;
    }

    @Override
    public long cost() {
        return this.req.cost();
    }
}

