/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.highlight;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import java.io.IOException;

public final class OffsetLimitTokenFilter
extends TokenFilter {
    private int offsetCount;
    private OffsetAttribute offsetAttrib = this.getAttribute(OffsetAttribute.class);
    private int offsetLimit;

    public OffsetLimitTokenFilter(TokenStream input, int offsetLimit) {
        super(input);
        this.offsetLimit = offsetLimit;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.offsetCount < this.offsetLimit && this.input.incrementToken()) {
            int offsetLength = this.offsetAttrib.endOffset() - this.offsetAttrib.startOffset();
            this.offsetCount += offsetLength;
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.offsetCount = 0;
    }
}

