/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.document.DocumentStoredFieldVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.StoredFieldVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreDoc;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopDocs;
import com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight.OffsetRange;
import com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategySupplier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MatchHighlighter {
    private final IndexSearcher searcher;
    private final OffsetsRetrievalStrategySupplier offsetsRetrievalStrategies;
    private final Analyzer analyzer;
    private final HashSet<String> fieldsAlwaysReturned = new HashSet();
    private final List<FieldValueHighlighter> fieldHighlighters = new ArrayList<FieldValueHighlighter>();

    public MatchHighlighter appendFieldHighlighter(FieldValueHighlighter highlighter) {
        this.fieldHighlighters.add(highlighter);
        this.fieldsAlwaysReturned.addAll(highlighter.alwaysFetchedFields());
        return this;
    }

    public void alwaysFetchFields(String ... fields) {
        for (String fld : fields) {
            this.fieldsAlwaysReturned.add(Objects.requireNonNull(fld));
        }
    }

    public MatchHighlighter(IndexSearcher searcher, Analyzer analyzer) {
        this(searcher, analyzer, MatchRegionRetriever.computeOffsetRetrievalStrategies(searcher.getIndexReader(), analyzer));
    }

    public MatchHighlighter(IndexSearcher searcher, Analyzer analyzer, OffsetsRetrievalStrategySupplier offsetsRetrievalStrategies) {
        this.searcher = searcher;
        this.offsetsRetrievalStrategies = offsetsRetrievalStrategies;
        this.analyzer = analyzer;
    }

    public Stream<DocHighlights> highlight(TopDocs topDocs, Query ... queries) throws IOException {
        LinkedHashMap docHits = new LinkedHashMap();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            docHits.put(scoreDoc.doc, null);
        }
        for (Query q : queries) {
            MatchRegionRetriever highlighter = new MatchRegionRetriever(this.searcher, this.searcher.rewrite(q), this.offsetsRetrievalStrategies);
            highlighter.highlightDocuments(topDocs, (docId, leafReader, leafDocId, hits) -> {
                DocHit docHit = (DocHit)docHits.get(docId);
                if (docHit == null) {
                    docHit = new DocHit(docId, leafReader, leafDocId);
                    docHits.put(docId, docHit);
                }
                docHit.addMatches(q, hits);
            });
        }
        return docHits.values().stream().filter(Objects::nonNull).map(this::computeDocFieldValues);
    }

    private DocHighlights computeDocFieldValues(DocHit docHit) {
        Document doc;
        try {
            doc = docHit.document(this.fieldsAlwaysReturned::contains);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        DocHighlights docHighlights = new DocHighlights(docHit.docId);
        HashSet<String> unique = new HashSet<String>();
        for (IndexableField indexableField : doc) {
            String field = indexableField.name();
            if (!unique.add(field)) continue;
            String[] values2 = doc.getValues(field);
            String contiguousValue = this.contiguousFieldValue(field, values2);
            List<OffsetRange> valueRanges = this.computeValueRanges(field, values2);
            List<QueryOffsetRange> offsets = docHit.matchRanges.get(field);
            List<String> formattedValues = this.fieldValueHighlighter(field, offsets != null).format(field, values2, contiguousValue, valueRanges, offsets);
            if (formattedValues == null) continue;
            docHighlights.fields.put(field, formattedValues);
        }
        return docHighlights;
    }

    private List<OffsetRange> computeValueRanges(String field, String[] values2) {
        ArrayList<OffsetRange> valueRanges = new ArrayList<OffsetRange>();
        int offset = 0;
        for (String v : values2) {
            valueRanges.add(new OffsetRange(offset, offset + v.length()));
            offset += v.length();
            offset += this.analyzer.getOffsetGap(field);
        }
        return valueRanges;
    }

    private String contiguousFieldValue(String field, String[] values2) {
        String value;
        if (values2.length == 1) {
            value = values2[0];
        } else {
            String fieldGapPadding = " ".repeat(this.analyzer.getOffsetGap(field));
            value = String.join((CharSequence)fieldGapPadding, values2);
        }
        return value;
    }

    private FieldValueHighlighter fieldValueHighlighter(String field, boolean hasMatches) {
        for (FieldValueHighlighter highlighter : this.fieldHighlighters) {
            if (!highlighter.isApplicable(field, hasMatches)) continue;
            return highlighter;
        }
        throw new RuntimeException("No field highlighter could be matched to field: " + field);
    }

    private static class DocHit {
        final int docId;
        private final LeafReader leafReader;
        private final int leafDocId;
        private final LinkedHashMap<String, List<QueryOffsetRange>> matchRanges = new LinkedHashMap();

        DocHit(int docId, LeafReader leafReader, int leafDocId) {
            this.docId = docId;
            this.leafReader = leafReader;
            this.leafDocId = leafDocId;
        }

        void addMatches(Query query, Map<String, List<OffsetRange>> hits) {
            hits.forEach((field, offsets) -> {
                List target = this.matchRanges.computeIfAbsent((String)field, fld -> new ArrayList());
                offsets.forEach(o -> target.add(new QueryOffsetRange(query, o.from, o.to)));
            });
        }

        Document document(final Predicate<String> needsField) throws IOException {
            DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(){

                @Override
                public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
                    return matchRanges.containsKey(fieldInfo.name) || needsField.test(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
                }
            };
            this.leafReader.storedFields().document(this.leafDocId, visitor);
            return visitor.getDocument();
        }
    }

    public static class QueryOffsetRange
    extends OffsetRange {
        public final Query query;

        QueryOffsetRange(Query query, int from, int to) {
            super(from, to);
            this.query = query;
        }

        @Override
        public QueryOffsetRange slice(int from, int to) {
            return new QueryOffsetRange(this.query, from, to);
        }
    }

    public static class DocHighlights {
        public final int docId;
        public final Map<String, List<String>> fields = new LinkedHashMap<String, List<String>>();

        public DocHighlights(int docId) {
            this.docId = docId;
        }
    }

    public static interface FieldValueHighlighter {
        public boolean isApplicable(String var1, boolean var2);

        public List<String> format(String var1, String[] var2, String var3, List<OffsetRange> var4, List<QueryOffsetRange> var5);

        default public Collection<String> alwaysFetchedFields() {
            return Collections.emptyList();
        }

        default public FieldValueHighlighter or(FieldValueHighlighter other) {
            final FieldValueHighlighter first = this;
            final FieldValueHighlighter second = other;
            final HashSet<String> fieldUnion = new HashSet<String>();
            fieldUnion.addAll(first.alwaysFetchedFields());
            fieldUnion.addAll(second.alwaysFetchedFields());
            return new FieldValueHighlighter(){

                @Override
                public boolean isApplicable(String field, boolean hasMatches) {
                    return first.isApplicable(field, hasMatches) || second.isApplicable(field, hasMatches);
                }

                @Override
                public List<String> format(String field, String[] values2, String contiguousValue, List<OffsetRange> valueRanges, List<QueryOffsetRange> matchOffsets) {
                    FieldValueHighlighter delegate = first.isApplicable(field, matchOffsets != null && !matchOffsets.isEmpty()) ? first : second;
                    return delegate.format(field, values2, contiguousValue, valueRanges, matchOffsets);
                }

                @Override
                public Collection<String> alwaysFetchedFields() {
                    return fieldUnion;
                }
            };
        }
    }
}

