/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util.fst;

import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.fst.FST;
import com.dataiku.dss.shadelib.org.apache.lucene.util.fst.Util;
import java.io.IOException;

abstract class FSTEnum<T> {
    protected final FST<T> fst;
    protected FST.Arc<T>[] arcs = new FST.Arc[10];
    protected T[] output = new Object[10];
    protected final T NO_OUTPUT;
    protected final FST.BytesReader fstReader;
    protected int upto;
    int targetLength;

    FSTEnum(FST<T> fst) {
        this.fst = fst;
        this.fstReader = fst.getBytesReader();
        this.NO_OUTPUT = fst.outputs.getNoOutput();
        fst.getFirstArc(this.getArc(0));
        this.output[0] = this.NO_OUTPUT;
    }

    protected abstract int getTargetLabel();

    protected abstract int getCurrentLabel();

    protected abstract void setCurrentLabel(int var1);

    protected abstract void grow();

    private void rewindPrefix() throws IOException {
        int cmp;
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1), this.fstReader);
            return;
        }
        int currentLimit = this.upto;
        this.upto = 1;
        while (this.upto < currentLimit && this.upto <= this.targetLength + 1 && (cmp = this.getCurrentLabel() - this.getTargetLabel()) >= 0) {
            if (cmp > 0) {
                FST.Arc<T> arc = this.getArc(this.upto);
                this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc, this.fstReader);
                break;
            }
            ++this.upto;
        }
    }

    protected void doNext() throws IOException {
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1), this.fstReader);
        } else {
            while (this.arcs[this.upto].isLast()) {
                --this.upto;
                if (this.upto != 0) continue;
                return;
            }
            this.fst.readNextArc(this.arcs[this.upto], this.fstReader);
        }
        this.pushFirst();
    }

    protected void doSeekCeil() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto);
        while (arc != null) {
            int targetLabel = this.getTargetLabel();
            if (arc.bytesPerArc() != 0 && arc.label() != -1) {
                FST.BytesReader in = this.fst.getBytesReader();
                if (arc.nodeFlags() == 64) {
                    arc = this.doSeekCeilArrayDirectAddressing(arc, targetLabel, in);
                    continue;
                }
                if (arc.nodeFlags() == 32) {
                    arc = this.doSeekCeilArrayPacked(arc, targetLabel, in);
                    continue;
                }
                assert (arc.nodeFlags() == 96);
                arc = this.doSeekCeilArrayContinuous(arc, targetLabel, in);
                continue;
            }
            arc = this.doSeekCeilList(arc, targetLabel);
        }
    }

    private FST.Arc<T> doSeekCeilArrayContinuous(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex >= arc.numArcs()) {
            this.rollbackToLastForkThenPush();
            return null;
        }
        if (targetIndex < 0) {
            this.fst.readArcByContinuous(arc, in, 0);
            assert (arc.label() > targetLabel);
            this.pushFirst();
            return null;
        }
        this.fst.readArcByContinuous(arc, in, targetIndex);
        assert (arc.label() == targetLabel);
        this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
        if (targetLabel == -1) {
            return null;
        }
        this.setCurrentLabel(arc.label());
        this.incr();
        return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
    }

    private FST.Arc<T> doSeekCeilArrayDirectAddressing(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex >= arc.numArcs()) {
            this.rollbackToLastForkThenPush();
            return null;
        }
        if (targetIndex < 0) {
            targetIndex = -1;
        } else if (FST.Arc.BitTable.isBitSet(targetIndex, arc, in)) {
            this.fst.readArcByDirectAddressing(arc, in, targetIndex);
            assert (arc.label() == targetLabel);
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        int ceilIndex = FST.Arc.BitTable.nextBitSet(targetIndex, arc, in);
        assert (ceilIndex != -1);
        this.fst.readArcByDirectAddressing(arc, in, ceilIndex);
        assert (arc.label() > targetLabel);
        this.pushFirst();
        return null;
    }

    private FST.Arc<T> doSeekCeilArrayPacked(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int idx = Util.binarySearch(this.fst, arc, targetLabel);
        if (idx >= 0) {
            this.fst.readArcByIndex(arc, in, idx);
            assert (arc.arcIdx() == idx);
            assert (arc.label() == targetLabel) : "arc.label=" + arc.label() + " vs targetLabel=" + targetLabel + " mid=" + idx;
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if ((idx = -1 - idx) == arc.numArcs()) {
            this.fst.readArcByIndex(arc, in, idx - 1);
            assert (arc.isLast());
            --this.upto;
            while (true) {
                if (this.upto == 0) {
                    return null;
                }
                FST.Arc<T> prevArc = this.getArc(this.upto);
                if (!prevArc.isLast()) {
                    this.fst.readNextArc(prevArc, this.fstReader);
                    this.pushFirst();
                    return null;
                }
                --this.upto;
            }
        }
        this.fst.readArcByIndex(arc, in, idx);
        assert (arc.label() > targetLabel);
        this.pushFirst();
        return null;
    }

    private FST.Arc<T> doSeekCeilList(FST.Arc<T> arc, int targetLabel) throws IOException {
        if (arc.label() == targetLabel) {
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if (arc.label() > targetLabel) {
            this.pushFirst();
            return null;
        }
        if (arc.isLast()) {
            --this.upto;
            while (true) {
                if (this.upto == 0) {
                    return null;
                }
                FST.Arc<T> prevArc = this.getArc(this.upto);
                if (!prevArc.isLast()) {
                    this.fst.readNextArc(prevArc, this.fstReader);
                    this.pushFirst();
                    return null;
                }
                --this.upto;
            }
        }
        this.fst.readNextArc(arc, this.fstReader);
        return arc;
    }

    void doSeekFloor() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto);
        while (arc != null) {
            int targetLabel = this.getTargetLabel();
            if (arc.bytesPerArc() != 0 && arc.label() != -1) {
                FST.BytesReader in = this.fst.getBytesReader();
                if (arc.nodeFlags() == 64) {
                    arc = this.doSeekFloorArrayDirectAddressing(arc, targetLabel, in);
                    continue;
                }
                if (arc.nodeFlags() == 32) {
                    arc = this.doSeekFloorArrayPacked(arc, targetLabel, in);
                    continue;
                }
                assert (arc.nodeFlags() == 96);
                arc = this.doSeekFloorContinuous(arc, targetLabel, in);
                continue;
            }
            arc = this.doSeekFloorList(arc, targetLabel);
        }
    }

    private FST.Arc<T> doSeekFloorContinuous(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex < 0) {
            return this.backtrackToFloorArc(arc, targetLabel, in);
        }
        if (targetIndex >= arc.numArcs()) {
            this.fst.readLastArcByContinuous(arc, in);
            assert (arc.label() < targetLabel);
            assert (arc.isLast());
            this.pushLast();
            return null;
        }
        this.fst.readArcByContinuous(arc, in, targetIndex);
        assert (arc.label() == targetLabel);
        this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
        if (targetLabel == -1) {
            return null;
        }
        this.setCurrentLabel(arc.label());
        this.incr();
        return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
    }

    private FST.Arc<T> doSeekFloorArrayDirectAddressing(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex < 0) {
            return this.backtrackToFloorArc(arc, targetLabel, in);
        }
        if (targetIndex >= arc.numArcs()) {
            this.fst.readLastArcByDirectAddressing(arc, in);
            assert (arc.label() < targetLabel);
            assert (arc.isLast());
            this.pushLast();
            return null;
        }
        if (FST.Arc.BitTable.isBitSet(targetIndex, arc, in)) {
            this.fst.readArcByDirectAddressing(arc, in, targetIndex);
            assert (arc.label() == targetLabel);
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        int floorIndex = FST.Arc.BitTable.previousBitSet(targetIndex, arc, in);
        assert (floorIndex != -1);
        this.fst.readArcByDirectAddressing(arc, in, floorIndex);
        assert (arc.label() < targetLabel);
        assert (arc.isLast() || this.fst.readNextArcLabel(arc, in) > targetLabel);
        this.pushLast();
        return null;
    }

    private void rollbackToLastForkThenPush() throws IOException {
        --this.upto;
        while (this.upto != 0) {
            FST.Arc<T> prevArc = this.getArc(this.upto);
            if (!prevArc.isLast()) {
                this.fst.readNextArc(prevArc, this.fstReader);
                this.pushFirst();
                return;
            }
            --this.upto;
        }
        return;
    }

    private FST.Arc<T> backtrackToFloorArc(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        while (true) {
            this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc, this.fstReader);
            if (arc.label() < targetLabel) {
                if (!arc.isLast()) {
                    if (arc.bytesPerArc() != 0 && arc.label() != -1) {
                        if (arc.nodeFlags() == 32) {
                            this.findNextFloorArcBinarySearch(arc, targetLabel, in);
                        } else if (arc.nodeFlags() == 64) {
                            this.findNextFloorArcDirectAddressing(arc, targetLabel, in);
                        } else {
                            assert (arc.nodeFlags() == 96);
                            this.findNextFloorArcContinuous(arc, targetLabel, in);
                        }
                    } else {
                        while (!arc.isLast() && this.fst.readNextArcLabel(arc, in) < targetLabel) {
                            this.fst.readNextArc(arc, this.fstReader);
                        }
                    }
                }
                assert (arc.label() < targetLabel);
                assert (arc.isLast() || this.fst.readNextArcLabel(arc, in) >= targetLabel);
                this.pushLast();
                return null;
            }
            --this.upto;
            if (this.upto == 0) {
                return null;
            }
            targetLabel = this.getTargetLabel();
            arc = this.getArc(this.upto);
        }
    }

    private void findNextFloorArcDirectAddressing(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        assert (arc.nodeFlags() == 64);
        assert (arc.label() != -1);
        assert (arc.label() == arc.firstLabel());
        if (arc.numArcs() > 1) {
            int targetIndex = targetLabel - arc.firstLabel();
            assert (targetIndex >= 0);
            if (targetIndex >= arc.numArcs()) {
                this.fst.readLastArcByDirectAddressing(arc, in);
            } else {
                int floorIndex = FST.Arc.BitTable.previousBitSet(targetIndex, arc, in);
                if (floorIndex > 0) {
                    this.fst.readArcByDirectAddressing(arc, in, floorIndex);
                }
            }
        }
    }

    private void findNextFloorArcContinuous(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        assert (arc.nodeFlags() == 96);
        assert (arc.label() != -1);
        assert (arc.label() == arc.firstLabel());
        if (arc.numArcs() > 1) {
            int targetIndex = targetLabel - arc.firstLabel();
            assert (targetIndex >= 0);
            if (targetIndex >= arc.numArcs()) {
                this.fst.readLastArcByContinuous(arc, in);
            } else {
                this.fst.readArcByContinuous(arc, in, targetIndex - 1);
            }
        }
    }

    private void findNextFloorArcBinarySearch(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        assert (arc.nodeFlags() == 32);
        assert (arc.label() != -1);
        assert (arc.arcIdx() == 0);
        if (arc.numArcs() > 1) {
            int idx = Util.binarySearch(this.fst, arc, targetLabel);
            assert (idx != -1);
            if (idx > 1) {
                this.fst.readArcByIndex(arc, in, idx - 1);
            } else if (idx < -2) {
                this.fst.readArcByIndex(arc, in, -2 - idx);
            }
        }
    }

    private FST.Arc<T> doSeekFloorArrayPacked(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int idx = Util.binarySearch(this.fst, arc, targetLabel);
        if (idx >= 0) {
            this.fst.readArcByIndex(arc, in, idx);
            assert (arc.arcIdx() == idx);
            assert (arc.label() == targetLabel) : "arc.label=" + arc.label() + " vs targetLabel=" + targetLabel + " mid=" + idx;
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if (idx == -1) {
            return this.backtrackToFloorArc(arc, targetLabel, in);
        }
        this.fst.readArcByIndex(arc, in, -2 - idx);
        assert (arc.isLast() || this.fst.readNextArcLabel(arc, in) > targetLabel);
        assert (arc.label() < targetLabel) : "arc.label=" + arc.label() + " vs targetLabel=" + targetLabel;
        this.pushLast();
        return null;
    }

    private FST.Arc<T> doSeekFloorList(FST.Arc<T> arc, int targetLabel) throws IOException {
        if (arc.label() == targetLabel) {
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if (arc.label() > targetLabel) {
            while (true) {
                this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc, this.fstReader);
                if (arc.label() < targetLabel) {
                    while (!arc.isLast() && this.fst.readNextArcLabel(arc, this.fstReader) < targetLabel) {
                        this.fst.readNextArc(arc, this.fstReader);
                    }
                    this.pushLast();
                    return null;
                }
                --this.upto;
                if (this.upto == 0) {
                    return null;
                }
                targetLabel = this.getTargetLabel();
                arc = this.getArc(this.upto);
            }
        }
        if (!arc.isLast()) {
            if (this.fst.readNextArcLabel(arc, this.fstReader) > targetLabel) {
                this.pushLast();
                return null;
            }
            return this.fst.readNextArc(arc, this.fstReader);
        }
        this.pushLast();
        return null;
    }

    boolean doSeekExact() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto - 1);
        int targetLabel = this.getTargetLabel();
        FST.BytesReader fstReader = this.fst.getBytesReader();
        while (true) {
            FST.Arc<T> nextArc;
            if ((nextArc = this.fst.findTargetArc(targetLabel, arc, this.getArc(this.upto), fstReader)) == null) {
                this.fst.readFirstTargetArc(arc, this.getArc(this.upto), fstReader);
                return false;
            }
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], nextArc.output());
            if (targetLabel == -1) {
                return true;
            }
            this.setCurrentLabel(targetLabel);
            this.incr();
            targetLabel = this.getTargetLabel();
            arc = nextArc;
        }
    }

    private void incr() {
        ++this.upto;
        this.grow();
        if (this.arcs.length <= this.upto) {
            FST.Arc[] newArcs = new FST.Arc[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, newArcs, 0, this.arcs.length);
            this.arcs = newArcs;
        }
        if (this.output.length <= this.upto) {
            Object[] newOutput = new Object[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.output, 0, newOutput, 0, this.output.length);
            this.output = newOutput;
        }
    }

    private void pushFirst() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        assert (arc != null);
        while (true) {
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (arc.label() == -1) break;
            this.setCurrentLabel(arc.label());
            this.incr();
            FST.Arc<T> nextArc = this.getArc(this.upto);
            this.fst.readFirstTargetArc(arc, nextArc, this.fstReader);
            arc = nextArc;
        }
    }

    private void pushLast() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        assert (arc != null);
        while (true) {
            this.setCurrentLabel(arc.label());
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (arc.label() == -1) break;
            this.incr();
            arc = this.fst.readLastTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
    }

    private FST.Arc<T> getArc(int idx) {
        if (this.arcs[idx] == null) {
            this.arcs[idx] = new FST.Arc();
        }
        return this.arcs[idx];
    }
}

