/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedObject;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.Destroyable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.LifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.Invocable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public interface Handler
extends LifeCycle,
Destroyable,
Request.Handler {
    @ManagedAttribute(value="The Server instance associated to this Handler", readonly=true)
    public Server getServer();

    public void setServer(Server var1);

    @ManagedObject
    public static class Sequence
    extends AbstractContainer
    implements Collection {
        private volatile List<Handler> _handlers = new ArrayList<Handler>();

        public Sequence(Handler ... handlers) {
            this(handlers == null || handlers.length == 0, handlers == null ? List.of() : List.of(handlers));
        }

        public Sequence(List<Handler> handlers) {
            this(handlers == null || handlers.isEmpty(), handlers);
        }

        public Sequence(boolean dynamic, List<Handler> handlers) {
            super(dynamic);
            this.setHandlers(handlers);
        }

        @Override
        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            for (Handler h2 : this._handlers) {
                if (!h2.handle(request, response, callback)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Handler> getHandlers() {
            return this._handlers;
        }

        @Override
        public void setHandlers(List<Handler> handlers) {
            if (!this.isDynamic() && this.isStarted()) {
                throw new IllegalStateException(this.getState());
            }
            List<Handler> newHandlers = this.newHandlers(handlers);
            Server server = this.getServer();
            Invocable.InvocationType serverInvocationType = server == null ? null : server.getInvocationType();
            Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
            for (Handler handler : newHandlers) {
                Container container;
                if (handler == null) continue;
                if (handler == this || handler instanceof Container && (container = (Container)handler).getDescendants().contains(this)) {
                    throw new IllegalStateException("setHandler loop");
                }
                invocationType = Invocable.combine(invocationType, handler.getInvocationType());
                if (server == null) continue;
                handler.setServer(server);
            }
            if (this.isDynamic() && server != null && server.isStarted() && serverInvocationType != invocationType && serverInvocationType != Invocable.InvocationType.BLOCKING) {
                throw new IllegalArgumentException("Cannot change invocation type of started server");
            }
            this.updateBeans(this._handlers, handlers);
            this._handlers = newHandlers;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            if (this.isDynamic()) {
                return Invocable.InvocationType.BLOCKING;
            }
            Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
            for (Handler handler : this._handlers) {
                invocationType = Invocable.combine(invocationType, handler.getInvocationType());
            }
            return invocationType;
        }

        protected List<Handler> newHandlers(List<Handler> handlers) {
            return handlers == null ? List.of() : List.copyOf(handlers);
        }
    }

    public static class Wrapper
    extends AbstractContainer
    implements Singleton {
        private Handler _handler;

        public Wrapper() {
            this((Handler)null);
        }

        public Wrapper(boolean dynamic) {
            this(dynamic, null);
        }

        public Wrapper(Handler handler) {
            this(false, handler);
        }

        public Wrapper(boolean dynamic, Handler handler) {
            super(dynamic);
            this._handler = handler == null ? null : Singleton.checkHandler(this, handler);
            this.installBean(this._handler);
        }

        @Override
        public Handler getHandler() {
            return this._handler;
        }

        @Override
        public void setHandler(Handler handler) {
            if (!this.isDynamic() && this.isStarted()) {
                throw new IllegalStateException(this.getState());
            }
            this._handler = Singleton.updateHandler(this, handler);
        }

        @Override
        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            Handler next = this.getHandler();
            return next != null && next.handle(request, response, callback);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            if (this.isDynamic()) {
                return Invocable.InvocationType.BLOCKING;
            }
            Handler next = this.getHandler();
            return next == null ? Invocable.InvocationType.NON_BLOCKING : next.getInvocationType();
        }
    }

    @ManagedObject
    public static abstract class AbstractContainer
    extends Abstract
    implements Container {
        private boolean _dynamic;

        protected AbstractContainer() {
            this(true);
        }

        protected AbstractContainer(boolean dynamic) {
            this._dynamic = dynamic;
        }

        @ManagedAttribute(value="Whether this Handler container is dynamic")
        public boolean isDynamic() {
            return this._dynamic;
        }

        public void setDynamic(boolean dynamic) {
            if (this.isStarted()) {
                throw new IllegalStateException(this.getState());
            }
            this._dynamic = dynamic;
        }

        @Override
        public <T extends Handler> List<T> getDescendants(Class<T> type) {
            ArrayList list = new ArrayList();
            this.expandHandler(this, list, type);
            return list;
        }

        private <H extends Handler> void expandHandler(Handler handler, List<H> list, Class<H> type) {
            if (!(handler instanceof Container)) {
                return;
            }
            Container container = (Container)handler;
            for (Handler child : container.getHandlers()) {
                if (type == null || type.isInstance(child)) {
                    list.add(child);
                }
                this.expandHandler(child, list, type);
            }
        }

        @Override
        public <T extends Handler> T getDescendant(Class<T> type) {
            return this.findHandler(this, type);
        }

        private <H extends Handler> H findHandler(Handler handler, Class<H> type) {
            if (!(handler instanceof Container)) {
                return null;
            }
            Container container = (Container)handler;
            for (Handler child : container.getHandlers()) {
                if (type == null || type.isInstance(child)) {
                    return (H)child;
                }
                H descendant = this.findHandler(child, type);
                if (descendant == null) continue;
                return descendant;
            }
            return null;
        }

        @Override
        public void setServer(Server server) {
            super.setServer(server);
            for (Handler child : this.getHandlers()) {
                child.setServer(server);
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            if (this._dynamic) {
                return Invocable.InvocationType.BLOCKING;
            }
            Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
            for (Handler child : this.getHandlers()) {
                invocationType = Invocable.combine(invocationType, child.getInvocationType());
            }
            return invocationType;
        }

        public static <T extends Container> T findContainerOf(Container root, Class<T> type, Handler handler) {
            if (root == null || handler == null) {
                return null;
            }
            List<T> branches = root.getDescendants(type);
            if (branches != null) {
                for (Container container : branches) {
                    List<?> candidates = container.getDescendants(handler.getClass());
                    if (candidates == null) continue;
                    for (Handler c : candidates) {
                        if (c != handler) continue;
                        return (T)container;
                    }
                }
            }
            return null;
        }
    }

    @ManagedObject
    public static abstract class Abstract
    extends ContainerLifeCycle
    implements Handler {
        private static final Logger LOG = LoggerFactory.getLogger(Abstract.class);
        private final Invocable.InvocationType _invocationType;
        private Server _server;

        public Abstract() {
            this(Invocable.InvocationType.BLOCKING);
        }

        public Abstract(Invocable.InvocationType type) {
            this._invocationType = type;
        }

        @Override
        @ManagedAttribute(value="The Server associated with this Handler", readonly=true)
        public Server getServer() {
            return this._server;
        }

        @Override
        public void setServer(Server server) {
            if (this._server == server) {
                return;
            }
            if (this.isStarted()) {
                throw new IllegalStateException(this.getState());
            }
            this._server = server;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this._invocationType;
        }

        @Override
        protected void doStart() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("starting {}", (Object)this);
            }
            if (this._server == null) {
                LOG.warn("No Server set for {}", (Object)this);
            }
            super.doStart();
        }

        @Override
        protected void doStop() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("stopping {}", (Object)this);
            }
            super.doStop();
        }

        @Override
        public void destroy() {
            if (this.isRunning()) {
                throw new IllegalStateException(this.getState());
            }
            super.destroy();
        }

        public static abstract class NonBlocking
        extends Abstract {
            public NonBlocking() {
                super(Invocable.InvocationType.NON_BLOCKING);
            }
        }
    }

    @ManagedObject
    public static interface Singleton
    extends Container {
        @ManagedAttribute(value="The child Handler of this Container", readonly=true)
        public Handler getHandler();

        public void setHandler(Handler var1);

        default public void setHandler(Supplier<Handler> supplier) {
            this.setHandler(supplier.get());
        }

        @Override
        default public List<Handler> getHandlers() {
            Handler next = this.getHandler();
            return next == null ? Collections.emptyList() : Collections.singletonList(next);
        }

        default public void insertHandler(Singleton handler) {
            Singleton tail = handler.getTail();
            if (tail.getHandler() != null) {
                throw new IllegalArgumentException("bad tail of inserted wrapper chain");
            }
            tail.setHandler(this.getHandler());
            this.setHandler(handler);
        }

        default public Singleton getTail() {
            Handler handler;
            Singleton tail = this;
            while ((handler = tail.getHandler()) instanceof Singleton) {
                Singleton wrapped;
                tail = wrapped = (Singleton)handler;
            }
            return tail;
        }

        public static Handler updateHandler(Singleton singleton, Handler handler) {
            Singleton.checkHandler(singleton, handler);
            if (singleton instanceof ContainerLifeCycle) {
                ContainerLifeCycle container = (ContainerLifeCycle)((Object)singleton);
                container.updateBean(singleton.getHandler(), handler);
            }
            return handler;
        }

        public static Handler checkHandler(Singleton singleton, Handler handler) {
            Container container;
            Invocable.InvocationType serverInvocationType;
            Server server = singleton.getServer();
            if (server != null && server.isStarted() && handler != null && (serverInvocationType = server.getInvocationType()) != Invocable.combine(serverInvocationType, handler.getInvocationType()) && serverInvocationType != Invocable.InvocationType.BLOCKING) {
                throw new IllegalArgumentException("Cannot change invocation type of started server");
            }
            if (handler == singleton || handler instanceof Container && (container = (Container)handler).getDescendants().contains(singleton)) {
                throw new IllegalStateException("Handler loop");
            }
            if (handler != null && server != null) {
                handler.setServer(server);
            }
            return handler;
        }
    }

    public static interface Collection
    extends Container {
        default public void addHandler(Handler handler) {
            ArrayList<Handler> list = new ArrayList<Handler>(this.getHandlers());
            list.add(handler);
            this.setHandlers(list);
        }

        default public boolean removeHandler(Handler handler) {
            ArrayList<Handler> list = new ArrayList<Handler>(this.getHandlers());
            boolean removed = list.remove(handler);
            if (removed) {
                this.setHandlers(list);
            }
            return removed;
        }

        default public void addHandler(Supplier<Handler> supplier) {
            this.addHandler(supplier.get());
        }

        public void setHandlers(List<Handler> var1);

        default public void setHandlers(Handler ... handlers) {
            this.setHandlers(handlers == null || handlers.length == 0 ? List.of() : List.of(handlers));
        }
    }

    @ManagedObject
    public static interface Container
    extends Handler {
        @ManagedAttribute(value="The direct children Handlers of this Container", readonly=true)
        public List<Handler> getHandlers();

        default public List<Handler> getDescendants() {
            return this.getDescendants(Handler.class);
        }

        default public <T extends Handler> List<T> getDescendants(Class<T> type) {
            ArrayList<Handler> handlers = new ArrayList<Handler>();
            for (Handler h2 : this.getHandlers()) {
                if (type.isInstance(h2)) {
                    Handler t2 = h2;
                    handlers.add(t2);
                }
                if (!(h2 instanceof Container)) continue;
                Container c = (Container)h2;
                handlers.addAll(c.getDescendants(type));
            }
            return handlers;
        }

        default public <T extends Handler> T getDescendant(Class<T> type) {
            for (Handler h2 : this.getHandlers()) {
                Container c;
                T t2;
                if (type.isInstance(h2)) {
                    Handler t3 = h2;
                    return (T)t3;
                }
                if (!(h2 instanceof Container) || (t2 = (c = (Container)h2).getDescendant(type)) == null) continue;
                return t2;
            }
            return null;
        }

        default public <T extends Container> T getContainer(Handler handler, Class<T> type) {
            if (handler == null) {
                return null;
            }
            for (Container container : this.getDescendants(type)) {
                if (!container.getDescendants(handler.getClass()).contains(handler)) continue;
                return (T)container;
            }
            return null;
        }
    }
}

