/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.MatchedResource;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.PathMappings;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.PathSpec;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.RegexPathSpec;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.ServletPathSpec;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.handler.ContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.Dumpable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.LifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.Configuration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.exception.WebSocketException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.Handshaker;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.CreatorNegotiator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.HandshakerSelector;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketMappings
implements Dumpable,
LifeCycle.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketMappings.class);
    public static final String WEBSOCKET_MAPPING_ATTRIBUTE = WebSocketMappings.class.getName();
    private final PathMappings<WebSocketNegotiator> mappings = new PathMappings();
    private final WebSocketComponents components;
    private final Handshaker handshaker = new HandshakerSelector();

    public static WebSocketMappings getMappings(ContextHandler contextHandler) {
        return (WebSocketMappings)contextHandler.getAttribute(WEBSOCKET_MAPPING_ATTRIBUTE);
    }

    public static WebSocketMappings ensureMappings(final ContextHandler contextHandler) {
        WebSocketMappings mappings = WebSocketMappings.getMappings(contextHandler);
        if (mappings == null) {
            mappings = new WebSocketMappings(WebSocketServerComponents.getWebSocketComponents(contextHandler));
            contextHandler.setAttribute(WEBSOCKET_MAPPING_ATTRIBUTE, mappings);
            contextHandler.addBean(mappings);
            final WebSocketMappings m4 = mappings;
            contextHandler.addEventListener(new LifeCycle.Listener(){

                @Override
                public void lifeCycleStopping(LifeCycle event) {
                    contextHandler.removeAttribute(WEBSOCKET_MAPPING_ATTRIBUTE);
                    contextHandler.removeEventListener(this);
                    contextHandler.removeBean(m4);
                }
            });
        }
        return mappings;
    }

    public static PathSpec parsePathSpec(String rawSpec) {
        if (rawSpec.charAt(0) == '/' || rawSpec.startsWith("*.") || rawSpec.startsWith("servlet|")) {
            return new ServletPathSpec(rawSpec);
        }
        if (rawSpec.charAt(0) == '^' || rawSpec.startsWith("regex|")) {
            return new RegexPathSpec(rawSpec);
        }
        if (rawSpec.startsWith("uri-template|")) {
            return new UriTemplatePathSpec(rawSpec.substring("uri-template|".length()));
        }
        throw new IllegalArgumentException("Unrecognized path spec syntax [" + rawSpec + "]");
    }

    public WebSocketMappings() {
        this(new WebSocketComponents());
    }

    public WebSocketMappings(WebSocketComponents components) {
        this.components = components;
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public Handshaker getHandshaker() {
        return this.handshaker;
    }

    @Override
    public void lifeCycleStopping(LifeCycle event) {
        this.clear();
    }

    public void clear() {
        this.mappings.reset();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.mappings);
    }

    public WebSocketNegotiator getWebSocketNegotiator(PathSpec pathSpec) {
        return this.mappings.get(pathSpec);
    }

    public WebSocketCreator getWebSocketCreator(PathSpec pathSpec) {
        WebSocketNegotiator negotiator = this.getWebSocketNegotiator(pathSpec);
        if (negotiator instanceof CreatorNegotiator) {
            return ((CreatorNegotiator)negotiator).getWebSocketCreator();
        }
        return null;
    }

    public void addMapping(PathSpec pathSpec, WebSocketCreator creator, FrameHandlerFactory factory, Configuration.Customizer customizer) throws WebSocketException {
        this.mappings.put(pathSpec, WebSocketNegotiator.from(creator, factory, customizer));
    }

    public void addMapping(PathSpec pathSpec, WebSocketNegotiator negotiator) throws WebSocketException {
        this.mappings.put(pathSpec, negotiator);
    }

    public boolean removeMapping(PathSpec pathSpec) {
        return this.mappings.remove(pathSpec) != null;
    }

    public WebSocketNegotiator getMatchedNegotiator(Request request, BiConsumer<Request, PathSpec> consumer) {
        String target = Request.getPathInContext(request);
        MatchedResource<WebSocketNegotiator> mapping = this.mappings.getMatched(target);
        if (mapping == null) {
            return null;
        }
        consumer.accept(request, mapping.getPathSpec());
        WebSocketNegotiator negotiator = mapping.getResource();
        if (LOG.isDebugEnabled()) {
            LOG.debug("WebSocket Negotiated detected on {} for endpoint {}", (Object)request, (Object)negotiator);
        }
        return negotiator;
    }

    public boolean upgrade(Request request, Response response, Callback callback, Configuration.Customizer defaultCustomizer) throws WebSocketException {
        WebSocketNegotiator negotiator = this.getMatchedNegotiator(request, WebSocketMappings::storePathSpec);
        return this.upgrade(negotiator, request, response, callback, defaultCustomizer);
    }

    private static void storePathSpec(Request request, PathSpec pathSpec) {
        request.setAttribute(PathSpec.class.getName(), pathSpec);
    }

    public boolean upgrade(WebSocketNegotiator negotiator, Request request, Response response, Callback callback, Configuration.Customizer defaultCustomizer) throws WebSocketException {
        if (negotiator == null) {
            return false;
        }
        return this.handshaker.upgradeRequest(negotiator, request, response, callback, this.components, defaultCustomizer);
    }
}

