(function() {
    'use strict';

    const app = angular.module('dataiku.fm.login', ['dataiku.services', 'dataiku.filters', "dataiku.fm.dialogs"]);

    app.controller('LoginController', function($scope, $state, $location, FMAPI, TopNav, LoggerProvider) {
        const Logger = LoggerProvider.getLogger('LoginController');
        $scope.waitForLoggedInCheck = false;
        if ($scope.appConfig.loggedIn) {
            $state.go("instances.list");
            return;
        }
        $scope.waitForLoggedInCheck = true;
        TopNav.setLocation(TopNav.LOGIN, "login");
        $scope.ssoEnabled = false;
        FMAPI.core.getConfiguration().success(function(data) {
            $scope.ssoEnabled = data.ssoLoginEnabled;
        });
        $scope.submit = function() {
            const formTenant = $("input[name=tenant]").val();
            const formLogin = $("input[name=login]").val();
            const formPassword = $("input[name=password]").val();

            $scope.loginFailed = false;
            $scope.loginErrorMessage = '';
            FMAPI.auth.login(formTenant, formLogin, formPassword).success(function() {
                /* Only follow redirects to a local path, not to another site */
                const redirectTo = $state.params.redirectTo;
                // We only redirect if the redirection starts with '/' + a letter/number/dash/underscore to avoid security breach.
                if (/^\/(?![/.])/.test(redirectTo)) {
                    Logger.info("GO " + redirectTo);
                    // ui-router does not seem to manage changes of $location.url ... It just does not do anything
                    // And since I have a URL, I can't use transitionTo
                    // SO I have to reload. It sucks
                    window.location = redirectTo;
                } else {
                    // I also do it here to ensure that we reload appConfig
                    window.location = "/";
                }
            }).error(function(data, status, headers) {
                $scope.loginFailed = true;
                if (data.errorType) {
                    $scope.loginError = getErrorDetails(data, status, headers)
                } else {
                    $scope.loginErrorMessage = data;
                }
            });
        };

        $scope.redirectToSSO = function() {
            window.location = "/";
        }
    });

}());
