// From https://medium.com/@kentcdodds/counting-angularjs-watchers-11c5134dc2ef
window._dkuGetAngularJSWatchers = function (root, deepOnly = false) {
    root = angular.element(root || document.documentElement);

    function getElemWatchers(element) {
        const isolateWatchers = getWatchersFromScope(element.data().$isolateScope);
        const scopeWatchers = getWatchersFromScope(element.data().$scope);
        let watchers = scopeWatchers.concat(isolateWatchers);
        angular.forEach(element.children(), function (childElement) {
            watchers = watchers.concat(getElemWatchers(angular.element(childElement)));
        });
        return watchers;
    }

    function getWatchersFromScope(scope) {
        if (scope) {
            return scope.$$watchers || [];
        } else {
            return [];
        }
    }

    return getElemWatchers(root).filter(watcher => !deepOnly || watcher.eq);
};
