(function() {
    'use strict';

    /**
     * <dropdown-number-formatting-button
     *    open-section="openSection"
     *    chart-def-key="chartDefKey"
     *    list-index="listIndex"
     *    toggle-contextual-menu="toggleContextualMenu"
     * >
     * </dropdown-number-formatting-button>
     *
     */
    angular.module('dataiku.charts').component('dropdownNumberFormattingButton', {
        templateUrl: 'static/dataiku/js/simple_report/components/dropdown-number-formatting-button/dropdown-number-formatting-button.html',
        bindings: {
            openSection: '=',
            chartDefKey: '=',
            toggleContextualMenu: '=',
            listIndex: '='
        },
        controller: function(ChartFormattingPaneSections, CHART_FORMATTING_PANE_PROPERTIES, FormattingPaneValues, $scope, translate) {
            $scope.translate = translate;
            const ctrl = this;

            ctrl.openFormattingPane = function(event) {
                const { openSection, chartDefKey, listIndex, toggleContextualMenu } = ctrl;
                toggleContextualMenu(event);

                const measureOrDimensionId = FormattingPaneValues.computeMeasureOrDimensionUniqueId(chartDefKey, listIndex);
                openSection(ChartFormattingPaneSections.DATA_VALUES, {
                    [CHART_FORMATTING_PANE_PROPERTIES.DATA_VALUES_SELECTED_MEASURE_DIMENSION_KEY]: measureOrDimensionId
                });
                if (chartDefKey === 'genericMeasures' && FormattingPaneValues.valuesDisplayed$.getValue() === false) {
                    // then open also the values in chart section if this section is displayed
                    openSection(ChartFormattingPaneSections.VALUES, {
                        [CHART_FORMATTING_PANE_PROPERTIES.VALUES_DISPLAY_SELECTED_MEASURE_KEY]: measureOrDimensionId
                    });
                }
            };

        }
    });
})();
