(function() {
    'use strict';

    angular.module('dataiku.shared').component('objectEditionButtons', {
        bindings: {
            'save': '<',                            // function((optional)commitMessage)
            'navigateToView': '<',                  // function()
            'canSave': '<',                         // boolean
            'isDirty': '<',                         // boolean
            'objectId': '<',                        // string
            'objectType': '<',                      // string
            'canWriteOverride': '<',                // for when you can save without having the write permission on the project (dashboard)
            'dropdownAlignRight': '<'               // boolean
        },
        templateUrl : '/static/dataiku/shared/components/object-edition-buttons/object-edition-buttons.component.html',
        controller: function(CreateModalFromTemplate, $rootScope, translate) {
            const ctrl = this;

            ctrl.translate = translate;
    
            let unwatchProjectSummary;

            ctrl.$onInit = function() {
                // Watches for projectSummary changes, as it is loaded asynchronously
                unwatchProjectSummary = $rootScope.$watch('projectSummary', function(newVal) {
                    if (newVal) {
                        ctrl.updateButtonStates();
                    }
                });
            };

            ctrl.$onDestroy = function() {
                if (unwatchProjectSummary) {
                    unwatchProjectSummary();
                }
            };

            ctrl.$onChanges = function() {
                ctrl.updateButtonStates();
            };

            ctrl.updateButtonStates = function() {
                if (!$rootScope.projectSummary) {
                    // Sets safe defaults when projectSummary is not available
                    ctrl.canSaveWithCustomCommitMessage = false;
                    ctrl.canCommit = false;
                    ctrl.canWrite = ctrl.canWriteOverride || false;
                    return;
                }

                ctrl.canSaveWithCustomCommitMessage = $rootScope.projectSummary.commitMode !== 'ALL_EXPLICIT' && (ctrl.objectType !== 'RECIPE' || $rootScope.projectSummary.commitMode !== 'RECIPES_EXPLICIT');
                ctrl.canCommit = $rootScope.projectSummary.commitMode === 'ALL_EXPLICIT' || (ctrl.objectType === 'RECIPE' && $rootScope.projectSummary.commitMode === 'RECIPES_EXPLICIT');
                ctrl.canWrite = $rootScope.projectSummary.canWriteProjectContent || ctrl.canWriteOverride;
            };

            ctrl.saveWithCustomCommitMessage = function () {
                CreateModalFromTemplate("/templates/git/commit-message-only-modal.html", $rootScope.$new(), null, function(newScope) {
                    newScope.commitData = {};
                    /* Reload previous message if any */
                    if (ctrl.currentSaveCommitMessage) {
                        newScope.commitData.message = ctrl.currentSaveCommitMessage;
                    }

                    newScope.commit = function(){
                        newScope.resolveModal(newScope.commitData);
                    };
                }, true).then(function(commitData){
                    ctrl.currentSaveCommitMessage = commitData.message;
                    ctrl.save(commitData.message);
                });
            };

            ctrl.commit = function() {
                CreateModalFromTemplate("/templates/git/commit-object-modal.html", $rootScope.$new(), null, function(newScope) {
                    newScope.object = {
                        objectType : ctrl.objectType,
                        objectId : ctrl.objectId
                    };
                }, true);
            };
        }
    });

})();
