(function() {
    'use strict';

    angular.module('dataiku.shared').component('pivotFilterFacet', {
        bindings: {
            filterTmpData: '<', // FilterTmpData
            filterFacet: '<', // FilterFacet
            facetUiState: '<', // FacetUiState
            filters: '<', // FrontendChartFilter[]
            index: '<', // number
            getFiltersRequestOptions: '<', // () => FiltersRequestOptions
            dateFilterTypeChange: '&', // ({ $dateFilterType }) => void
            filterTmpDataChange: '&', // ({ $filterTmpData }) => void
        },
        templateUrl: '/static/dataiku/shared/components/pivot-filter-facet/pivot-filter-facet.component.html',
        controller: function(ChartFilterUtils) {
            const ctrl = this;

            ctrl.isDateFilter = ChartFilterUtils.isDateFilter.bind(ChartFilterUtils);
            ctrl.isNumericalFilter = ChartFilterUtils.isNumericalFilter.bind(ChartFilterUtils);
            ctrl.isNumericalRangeFilter = ChartFilterUtils.isNumericalRangeFilter.bind(ChartFilterUtils);
            ctrl.isTrueAlphanumericalFilter = ChartFilterUtils.isTrueAlphanumericalFilter.bind(ChartFilterUtils);
            ctrl.isCustomFilter = ChartFilterUtils.isCustomFilter.bind(ChartFilterUtils);
            ctrl.isRelativeDateFilter = ChartFilterUtils.isRelativeDateFilter.bind(ChartFilterUtils);

            ctrl.handleFilterTmpDataChange = function(filterTmpData) {
                ctrl.filterTmpDataChange({ $filterTmpData: filterTmpData });
            };

            ctrl.handleDateFilterTypeChange = function(dateFilterType) {
                ctrl.dateFilterTypeChange({ $dateFilterType: dateFilterType });
            };
        }
    });
})();
