/* global describe, it, inject, expect, module, beforeEach */

describe('KpiHolderController', function () {
	let $componentController, ctrl, scope, element;
	const VALUE_SELECTOR = 'kpi-holder-measure__value';
	const LABEL_SELECTOR = 'kpi-holder-measure__label';
	const dummyInjection = { ChartTensorDataWrapper: {}, ChartFormatting: {}, ChartLabels: {}, ChartsStaticData: {} };

	beforeEach(module('dataiku.charts'));
    beforeEach(module('dataiku.mock'));
	beforeEach(inject(function (_$componentController_, $rootScope) {
		$componentController = _$componentController_;
		scope = $rootScope;
		element = angular.element('<div>default</div>');
	}));

	beforeEach(() => {
		const bindings = { data: {}, chartDef: {} };
		ctrl = $componentController('kpiHolder', { $scope: scope, $element: element, ...dummyInjection }, bindings);
	});

	it('should create component controller', function () {
		expect(ctrl).toBeDefined();
	});

	it('should correctly assign el attribute', function () {
		expect(ctrl.el).toBeDefined();
		expect(ctrl.el.innerHTML).toEqual('default');
	});

	it('should be listening on window-resized-kpi event', function () {
		expect(scope.$$listeners).toBeDefined()
		expect(scope.$$listeners['window-resized-kpi']).toBeDefined();
		expect(scope.$$listeners['window-resized-kpi'].length).toEqual(1);
	});

	it('applyFontSize correctly set div height and span font-size with extra line-height', function () {
		const div = angular.element('<div><span>test</span></div>')[0];
		ctrl.applyFontSize(div, 34);
		expect(div.style.fontSize).toEqual('34px');
		expect(div.style.lineHeight).toEqual('40px');

		ctrl.applyFontSize(div, 1233);
		expect(div.style.fontSize).toEqual('1233px');
		expect(div.style.lineHeight).toEqual('1443px');
	});

	it('sanitizeKpi set default text-content, font-size & line-height', function () {
		const element = angular.element(`
      		<div>
      			<div class=${VALUE_SELECTOR} style="font-size:45px; line-height:45px;">value</div>
      		    <div class=${LABEL_SELECTOR} style="display: none; width:45px; font-size: 16px">label</div>
      		</div>`);
		ctrl = $componentController('kpiHolder', { $scope: scope, $element: element, ...dummyInjection }, {});
		const valueDom = ctrl.el.getElementsByClassName(VALUE_SELECTOR)[0];
		const labelDom = ctrl.el.getElementsByClassName(LABEL_SELECTOR)[0];

		expect(valueDom.style.fontSize).toEqual('45px');
		expect(valueDom.style.lineHeight).toEqual('45px');
		expect(valueDom.textContent).toEqual('value');

		expect(labelDom.style.width).toEqual('45px');
		expect(labelDom.style.display).toEqual('none');
		expect(labelDom.style.fontSize).toEqual('16px');
		expect(labelDom.textContent).toEqual('label');

		ctrl.sanitizeKpi(0);

		expect(valueDom.style.fontSize).toEqual('1px');
		expect(valueDom.style.lineHeight).toEqual('1px');
		expect(valueDom.textContent).toEqual(' ');

		expect(labelDom.style.width).toEqual('');
		expect(labelDom.style.display).toEqual('');
		expect(labelDom.textContent).toEqual(' ');
		// kpi label is not sanitized as we keep a default font-size
		expect(labelDom.style.fontSize).toEqual('16px');

	});

	it('fitKpiValueToContainer correctly find and return an appropriate font-size', function () {
		const kpiValue = angular.element(`<div class=${VALUE_SELECTOR}>Hello</div>`)[0];
		kpiValue.style.display = 'inline-block';
		document.body.appendChild(kpiValue);

		expect(ctrl.fitKpiValueToContainer(kpiValue, { width: 500, height: 100 }, 15)).toEqual(65);
		expect(ctrl.fitKpiValueToContainer(kpiValue, { width: 500, height: 100 }, 0)).toEqual(77);

		expect(ctrl.fitKpiValueToContainer(kpiValue, { width: 500, height: 200 }, 100)).toEqual(69);
		expect(ctrl.fitKpiValueToContainer(kpiValue, { width: 500, height: 200 }, 0)).toEqual(154);

		expect(ctrl.fitKpiValueToContainer(kpiValue, { width: 500, height: 500 }, 0)).toEqual(203);
		expect(ctrl.fitKpiValueToContainer(kpiValue, { width: 2000, height: 2000 }, 15)).toEqual(500);
	});
});