# encoding: utf-8
"""
Executor for containerized execution of python training recipe.
"""

import json
import logging

from dataiku.base.utils import ErrorMonitoringWrapper
from .runner import setup_log, read_execution

if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']

    with ErrorMonitoringWrapper():
        logging.info("Launching doctor main")
        if execution['type'] == 'RECIPE_PREDICTION_TRAIN_PYTHON':
            from dataiku.doctor.prediction.reg_train_recipe import main
            desc = json.loads(execution['payload'])
            main(execution["contextPath"], desc['operationMode'])
        elif execution['type'] == 'RECIPE_PREDICTION_TRAIN_DEEPHUB':
            from dataiku.doctor.deephub.launch_training_recipe import main
            main(execution["contextPath"])
        elif execution['type'] == 'RECIPE_PREDICTION_TRAIN_TIMESERIES':
            from dataiku.doctor.timeseries.train.launch_training_recipe import main
            desc = json.loads(execution['payload'])
            main(execution["contextPath"], desc['operationMode'])
        elif execution['type'] == 'RECIPE_PREDICTION_TRAIN_CAUSAL':
            from dataiku.doctor.causal.train.launch_training_recipe import main
            desc = json.loads(execution['payload'])
            main(execution["contextPath"], desc['operationMode'])
        elif execution['type'] == 'RECIPE_CLUSTERING_TRAIN_PYTHON':
            from dataiku.doctor.clustering.reg_train_recipe import main
            main(execution["contextPath"])
        else:
            raise Exception("Unsupported training recipe type: %s" % execution['type'])


