import numpy as np
import pytest
from scipy import sparse

from dataiku.doctor.prediction.prediction_interval_model import PredictionIntervalsModel


def test_fit_and_intervals_with_sparse_matrix():
    model = PredictionIntervalsModel.for_training({"algorithm": "LIGHTGBM_REGRESSION",
                                                   "predictionIntervalsEnabled": True,
                                                   "predictionIntervalsCoverage": .95
                                                   })
    X = sparse.csr_matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
    error = np.array([0.1, 0.2, 0.3])
    preds = np.array([1.0, 1.5, 2.0])

    model.fit(X, error)
    assert model.params.q == pytest.approx(0.4)

    np.testing.assert_almost_equal(model.predict(X) , [0.1, 0.1, 0.1])