from dataiku.eda.types import Literal

import numpy as np

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import MaxModel, MaxResultModel


class Max(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["max"]:
        return "max"

    @staticmethod
    def build(params: MaxModel) -> 'Max':
        return Max(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> MaxResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()

        return {"type": self.get_type(), "value": np.max(series)}
