/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.rpc;

import com.dataiku.common.rpc.PEMUtils;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.ClientProtocolException;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.dataiku.dss.shadelib.org.apache.http.config.Registry;
import com.dataiku.dss.shadelib.org.apache.http.config.RegistryBuilder;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.InputStreamEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.HttpMultipartMode;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ByteArrayBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ContentBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.FileBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.InputStreamBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.StringBody;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClients;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.dataiku.dss.shadelib.org.apache.http.ssl.SSLContexts;
import com.dataiku.dss.shadelib.org.apache.http.ssl.TrustStrategy;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class InternalAPIClient
implements AutoCloseable {
    protected String baseURI;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();
    private CloseableHttpClient httpClient;
    private final int connectTimeout;
    private final int socketTimeout;
    private final PoolingHttpClientConnectionManager cm;
    private static Logger logger = Logger.getLogger((String)"dku.api.client");

    protected InternalAPIClient(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates) {
        this(baseURI, serverCertPEM, trustAllSSLCertificates, null, 0, 0);
    }

    protected InternalAPIClient(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings, int connectTimeout, int socketTimeout) {
        this.baseURI = baseURI;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        RequestConfig config = RequestConfig.custom().setSocketTimeout(this.getSocketTimeout()).setConnectTimeout(this.getConnectTimeout()).build();
        HttpClientBuilder builder = HttpClients.custom();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings(proxySettings, builder);
        if (StringUtils.isNotBlank((String)serverCertPEM)) {
            logger.info((Object)"Enabling manual trust of server cert");
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(PEMUtils.createTrustStoreFromPEM(serverCertPEM), null).build();
                Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
                this.cm = new PoolingHttpClientConnectionManager(registry);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to trust certificates", e);
            }
        } else if (trustAllSSLCertificates) {
            logger.info((Object)"Enabling trust of all certificates");
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
                Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
                this.cm = new PoolingHttpClientConnectionManager(registry);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to trust certificates", e);
            }
        } else {
            this.cm = new PoolingHttpClientConnectionManager();
        }
        builder.setConnectionManager((HttpClientConnectionManager)this.cm).setDefaultRequestConfig(config);
        this.cm.setMaxTotal(10);
        this.cm.setDefaultMaxPerRoute(10);
        this.httpClient = builder.build();
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close API client", (Throwable)e);
        }
    }

    protected abstract HttpGet newGet(String var1) throws Exception;

    protected abstract HttpPost newPost(String var1) throws Exception;

    protected abstract HttpPut newPut(String var1) throws Exception;

    protected abstract HttpDelete newDelete(String var1) throws Exception;

    public void setMaxTotalConnections(int max) {
        this.cm.setMaxTotal(max);
    }

    public void setDefaultMaxConnectionsPerRoute(int max) {
        this.cm.setDefaultMaxPerRoute(max);
    }

    protected void setAdditionalHeadersInRequest(HttpRequestBase req) {
        for (Map.Entry<String, String> e : this.additionalHeaders.entrySet()) {
            req.setHeader(e.getKey(), e.getValue());
        }
        MainLoggingConfigurator.ProcessType processType = DKUApp.getProcessType();
        if (processType != null) {
            req.setHeader("X-DKU-CallOrigin", processType.name());
        }
    }

    public void addHeader(String key, String value) {
        this.additionalHeaders.put(key, value);
    }

    public void addHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.additionalHeaders.put(e.getKey(), e.getValue());
        }
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }

    protected int getSocketTimeout() {
        return this.socketTimeout;
    }

    protected HttpPost newJSONPost(String method, Object arg) throws Exception {
        HttpPost post = this.newPost(method);
        post.setHeader("Content-Type", "application/json");
        post.setEntity(JSON.toHttpEntity((Object)arg));
        return post;
    }

    protected HttpPost newJSONPost(String method, int timeout, Object arg) throws Exception {
        HttpPost post = this.newPost(method);
        post.setHeader("Content-Type", "application/json");
        HttpConnectionParams.setConnectionTimeout((HttpParams)post.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)post.getParams(), (int)timeout);
        post.setEntity(JSON.toHttpEntity((Object)arg));
        return post;
    }

    protected HttpPut newJSONPut(String method, Object arg) throws Exception {
        HttpPut put = this.newPut(method);
        put.setEntity(JSON.toHttpEntity((Object)arg));
        return put;
    }

    protected HttpPut newJSONPut(String method, int timeout, Object arg) throws Exception {
        HttpPut post = this.newPut(method);
        HttpConnectionParams.setConnectionTimeout((HttpParams)post.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)post.getParams(), (int)timeout);
        post.setEntity(JSON.toHttpEntity((Object)arg));
        return post;
    }

    protected HttpPost newAnyPost(String method, HttpEntity entity) throws Exception {
        HttpPost post = this.newPost(method);
        post.setEntity(entity);
        return post;
    }

    protected HttpPost newAnyPost(String method, int timeout, HttpEntity entity) throws Exception {
        HttpPost post = this.newPost(method);
        HttpConnectionParams.setConnectionTimeout((HttpParams)post.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)post.getParams(), (int)timeout);
        post.setEntity(entity);
        return post;
    }

    public <T> T get(String method, Class<T> ofClazz) throws IOException {
        HttpResponse resp = this.doSimpleGet(method);
        return this.handleJSONRespAndConsume(resp, ofClazz);
    }

    public <T> T get(String method, TypeToken<T> ofClazz) throws IOException {
        HttpResponse resp = this.doSimpleGet(method);
        return this.handleJSONRespAndConsume(resp, ofClazz);
    }

    private HttpResponse doSimpleGet(String method) throws IOException, ClientProtocolException {
        HttpGet get;
        try {
            get = this.newGet(method);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.httpClient.execute((HttpUriRequest)get);
    }

    public <T> T getForm(String method, Class<T> ofClazz, Object ... args) throws IOException {
        HttpResponse resp = this.doGetWithForm(method, args);
        return this.handleJSONRespAndConsume(resp, ofClazz);
    }

    public <T> T getForm(String method, TypeToken<T> ofClazz, Object ... args) throws IOException {
        HttpResponse resp = this.doGetWithForm(method, args);
        return this.handleJSONRespAndConsume(resp, ofClazz);
    }

    public String getFormToString(String method, Object ... args) throws IOException {
        HttpResponse resp = this.doGetWithForm(method, args);
        return this.handleStringRespAndConsume(resp);
    }

    private HttpResponse doGetWithForm(String method, Object ... args) throws IOException, ClientProtocolException {
        HttpGet get = this.prepareGetWithForm(method, args);
        return this.httpClient.execute((HttpUriRequest)get);
    }

    private HttpGet prepareGetWithForm(String method, Object ... args) throws IOException {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            return this.newGet(method + "?" + URLEncodedUtils.format(nvps, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
    }

    public InputStream getToInputStream(String method) throws IOException {
        HttpGet get;
        try {
            get = this.newGet(method);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.handleInputStreamResp((HttpResponse)this.httpClient.execute((HttpUriRequest)get));
    }

    public InputStream getFormToInputStream(String method, Object ... args) throws IOException {
        HttpGet get = this.prepareGetWithForm(method, args);
        return this.handleInputStreamResp((HttpResponse)this.httpClient.execute((HttpUriRequest)get));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T postObject(String method, Class<T> ofClazz, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                pm.abort();
            }
        });){
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
            T t = this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
            return t;
        }
        catch (APIError.APIErrorException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ResponseStringWithHeaders postObjectToStringResponseAndHeaders(String method, Object arg) throws IOException {
        ResponseStringWithHeaders responseStringWithHeaders;
        block12: {
            HttpPost pm;
            try {
                pm = this.newJSONPost(method, arg);
            }
            catch (Exception e) {
                throw new IOException("Failed to create request", e);
            }
            FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    pm.abort();
                }
            });
            try {
                CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
                ResponseStringWithHeaders ret = new ResponseStringWithHeaders();
                ret.headers = Arrays.stream(resp.getAllHeaders()).filter(h -> StringUtils.isNotBlank((String)h.getName())).map(h -> new Pair((Object)h.getName(), (Object)h.getValue())).collect(Collectors.toList());
                ret.response = this.handleStringRespAndConsume((HttpResponse)resp);
                responseStringWithHeaders = ret;
                if (aborter == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (aborter != null) {
                        try {
                            aborter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (APIError.APIErrorException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            aborter.close();
        }
        return responseStringWithHeaders;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T putObject(String method, Class<T> ofClazz, Object arg) throws IOException {
        HttpPut pm;
        try {
            pm = this.newJSONPut(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                pm.abort();
            }
        });){
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
            T t = this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
            return t;
        }
        catch (APIError.APIErrorException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T> T postObject(String method, int timeout, Class<T> ofClazz, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, timeout, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postObject(String method, TypeToken<T> ofClazz, Object arg) throws IOException {
        HttpPost pm = this.createPostObject(method, arg);
        return this.executePostObject(pm, ofClazz);
    }

    public HttpPost createPostObject(String method, Object arg) throws IOException {
        try {
            return this.newJSONPost(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
    }

    public <T> T executePostObject(HttpPost pm, TypeToken<T> ofClazz) throws IOException {
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T putObject(String method, TypeToken<T> ofClazz, Object arg) throws IOException {
        HttpPut pm;
        try {
            pm = this.newJSONPut(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postObject(String method, int timeout, TypeToken<T> ofClazz, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, timeout, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postFormToJSON(String method, Class<T> ofClazz, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postFormAndFileToJSON(String method, Class<T> ofClazz, File file, String fileName, Object ... args) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new FileBody(file, ContentType.DEFAULT_BINARY, fileName));
        return this.postFormAndMultipartToJSON(method, ofClazz, builder, args);
    }

    public <T> T postFormAndFileToJSON(String method, Class<T> ofClazz, InputStream file, String fileName, Object ... args) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new InputStreamBody(file, ContentType.DEFAULT_BINARY, fileName));
        return this.postFormAndMultipartToJSON(method, ofClazz, builder, args);
    }

    public <T> T postFormAndFileToJSON(String method, Class<T> ofClazz, byte[] file, String fileName, Object ... args) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new ByteArrayBody(file, ContentType.DEFAULT_BINARY, fileName));
        return this.postFormAndMultipartToJSON(method, ofClazz, builder, args);
    }

    private <T> T postFormAndMultipartToJSON(String method, Class<T> ofClazz, MultipartEntityBuilder builder, Object ... args) throws IOException, ClientProtocolException {
        HttpPost post;
        logger.info((Object)"postFormAndMultiPart");
        logger.info((Object)("ARGS " + StringUtils.join((Object[])args, (String)" ")));
        for (int i = 0; i < args.length; i += 2) {
            builder.addPart((String)args[i], (ContentBody)new StringBody(String.valueOf(args[i + 1]), ContentType.MULTIPART_FORM_DATA));
        }
        try {
            HttpEntity entity = builder.build();
            post = this.newAnyPost(method, entity);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postFormToJSON(String method, TypeToken<T> ofClazz, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postFormToJSON(String method, int timeout, Class<T> ofClazz, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, timeout, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T postFormToJSON(String method, int timeout, TypeToken<T> ofClazz, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, timeout, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public String postFormToStringV(String method, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleStringRespAndConsume((HttpResponse)resp);
    }

    public String postFormToString(String method, List<Object> args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.size(); i += 2) {
            nvps.add(new BasicNameValuePair((String)args.get(i), String.valueOf(args.get(i + 1))));
        }
        try {
            post = this.newAnyPost(method, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleStringRespAndConsume((HttpResponse)resp);
    }

    public String postJSONToString(String method, Object body) throws IOException {
        HttpPost post;
        try {
            post = this.newJSONPost(method, body);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleStringRespAndConsume((HttpResponse)resp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T postAnyToJSON(String method, Class<T> ofClazz, HttpEntity entity) throws IOException {
        HttpPost pm;
        try {
            pm = this.newAnyPost(method, entity);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                pm.abort();
            }
        });){
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
            T t = this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
            return t;
        }
        catch (APIError.APIErrorException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public HttpEntity postJSONToStream(String method, Object arg) throws IOException {
        return this.postJSONToStreamAndRequest((String)method, (Object)arg).entity;
    }

    public EntityAndRequest postJSONToStreamAndRequest(String method, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        if (code == 200) {
            return new EntityAndRequest(resp.getEntity(), (HttpRequestBase)pm);
        }
        if (resp.getEntity().getContentType().getValue().startsWith("application/json")) {
            try {
                throw HTTPClientUtils.handleAPIError((HttpResponse)resp);
            }
            catch (Throwable throwable) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
                throw throwable;
            }
        }
        try {
            String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            throw new IOException("Unknown error on command: " + s);
        }
        catch (Throwable throwable) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            throw throwable;
        }
    }

    public HttpEntity postFormToStream(String method, Object ... args) throws IOException {
        return this.postFormToStreamWithTimeoutInternal(method, null, args);
    }

    public HttpEntity postFormToStreamWithTimeout(String method, Integer socketTimeout, Object ... args) throws IOException {
        return this.postFormToStreamWithTimeoutInternal(method, socketTimeout, args);
    }

    private HttpEntity postFormToStreamWithTimeoutInternal(String method, Integer socketTimeout, Object[] args) throws IOException {
        CloseableHttpResponse resp;
        int code;
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        if (socketTimeout != null) {
            RequestConfig config = RequestConfig.custom().setSocketTimeout(socketTimeout.intValue()).setConnectTimeout(this.getConnectTimeout()).build();
            post.setConfig(config);
        }
        if ((code = (resp = this.httpClient.execute((HttpUriRequest)post)).getStatusLine().getStatusCode()) == 204) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        if (code == 200) {
            return resp.getEntity();
        }
        if (resp.getEntity().getContentType().getValue().startsWith("application/json")) {
            try {
                logger.error((Object)("received error code " + code));
                throw HTTPClientUtils.handleAPIError((HttpResponse)resp);
            }
            catch (Throwable throwable) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
                throw throwable;
            }
        }
        try {
            String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            throw new IOException("Unknown error on command: " + s);
        }
        catch (Throwable throwable) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            throw throwable;
        }
    }

    public <T> T delete(String method, Class<T> ofClazz, Object ... args) throws IOException {
        HttpDelete pm;
        URIBuilder builder = new URIBuilder().setPath(method);
        for (int i = 0; i < args.length; i += 2) {
            builder.addParameter((String)args[i], String.valueOf(args[i + 1]));
        }
        String pathAndQuery = builder.toString();
        logger.info((Object)("DELETE PATH " + pathAndQuery));
        try {
            pm = this.newDelete(pathAndQuery);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)pm);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz) throws IOException {
        return this.handleJSONResp(resp, ofClazz, HTTPClientUtils::handleAPIError);
    }

    public <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz, HTTPClientUtils.ApiErrorHandler apiErrorHandle) throws IOException {
        return HTTPClientUtils.handleJSONResp(resp, ofClazz, apiErrorHandle);
    }

    public <T> T handleJSONResp(HttpResponse resp, TypeToken<T> ofClazz) throws IOException {
        return this.handleJSONResp(resp, ofClazz, HTTPClientUtils::handleAPIError);
    }

    public <T> T handleJSONResp(HttpResponse resp, TypeToken<T> ofClazz, HTTPClientUtils.ApiErrorHandler apiErrorHandle) throws IOException {
        return HTTPClientUtils.handleJSONResp(resp, ofClazz, apiErrorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleJSONRespAndConsume(HttpResponse resp, Class<T> ofClazz) throws IOException {
        try {
            T t = this.handleJSONResp(resp, ofClazz);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleJSONRespAndConsume(HttpResponse resp, TypeToken<T> ofClazz) throws IOException {
        try {
            T t = this.handleJSONResp(resp, ofClazz);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    public String handleStringResp(HttpResponse resp) throws IOException {
        return HTTPClientUtils.handleStringResp(resp);
    }

    private String handleStringRespAndConsume(HttpResponse resp) throws IOException {
        try {
            String string = this.handleStringResp(resp);
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    public InputStream handleInputStreamResp(HttpResponse resp) throws IOException {
        return HTTPClientUtils.handleInputStreamResp(resp);
    }

    public <T> FutureResponse<T> getFuture(FutureResponse<T> fr, TypeToken<FutureResponse<T>> clazz) throws Exception {
        return this.get("/dip/publicapi/futures/" + fr.jobId, clazz);
    }

    public <T> void waitCompletion(FutureResponse<T> initialFutureResponse) throws Exception {
        this.waitCompletion(initialFutureResponse, new TypeToken<FutureResponse<T>>(){}, null, null);
    }

    public <T> FutureResponse<T> waitCompletion(FutureResponse<T> fr, TypeToken<FutureResponse<T>> clazz, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder, @Nullable String prefix) throws Exception {
        String finalPrefix = StringUtils.isBlank((String)prefix) ? "" : prefix;
        int delay = 25;
        int lastAddedLineIndex = -1;
        while (!fr.hasResult) {
            if (logTailBuilder != null && fr.log != null && !fr.log.lines.isEmpty()) {
                while (lastAddedLineIndex < fr.log.lines.size() - 1) {
                    logTailBuilder.appendLine(finalPrefix + (String)fr.log.lines.get(++lastAddedLineIndex));
                }
            }
            Thread.sleep(delay);
            delay = Math.min(delay + 25, 500);
            fr = this.getFuture(fr, clazz);
        }
        if (logTailBuilder != null && fr.log != null && !fr.log.lines.isEmpty()) {
            while (lastAddedLineIndex < fr.log.lines.size() - 1) {
                logTailBuilder.appendLine(finalPrefix + (String)fr.log.lines.get(++lastAddedLineIndex));
            }
        }
        return fr;
    }

    public <T> T postFormAndStreamToJSON(String method, Class<T> ofClazz, final InputStream is, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newPost(method + "?" + URLEncodedUtils.format(nvps, (Charset)StandardCharsets.UTF_8));
            post.setHeader("Content-Type", "application/octet-stream");
            post.setEntity((HttpEntity)new InputStreamEntity(is){

                public void writeTo(OutputStream outStream) throws IOException {
                    if (is instanceof DataDestinationNotifier) {
                        ((DataDestinationNotifier)((Object)is)).accept(outStream);
                    }
                    super.writeTo(outStream);
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return this.handleJSONRespAndConsume((HttpResponse)resp, ofClazz);
    }

    public static class ResponseStringWithHeaders {
        public String response;
        public List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
    }

    public static class EntityAndRequest {
        public HttpRequestBase request;
        public HttpEntity entity;

        EntityAndRequest(HttpEntity entity, HttpRequestBase request) {
            this.entity = entity;
            this.request = request;
        }
    }

    public static interface DataDestinationNotifier
    extends Consumer<OutputStream> {
    }
}

