/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.rpc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class PEMUtils {
    public static KeyStore createTrustStoreFromPEM(String certificatePem) throws Exception {
        List<X509Certificate> certs = PEMUtils.createCertificatesFromPEM(certificatePem);
        if (certs.size() == 0) {
            throw new IllegalArgumentException("No certificate found in PEM");
        }
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("dss", certs.get(0));
        return keystore;
    }

    private static List<X509Certificate> createCertificatesFromPEM(String certificatePem) throws Exception {
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        try (BufferedReader r = new BufferedReader(new StringReader(certificatePem));){
            String line = r.readLine();
            if (line == null || !line.contains("BEGIN CERTIFICATE")) {
                throw new IllegalArgumentException("Bad PEM");
            }
            Object currentCert = "";
            while (line != null) {
                if (line.contains("END CERTIFICATE")) {
                    byte[] bytes = Base64.decodeBase64((String)currentCert);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
                    ret.add(x509Cert);
                    currentCert = "";
                } else if (!line.startsWith("----")) {
                    currentCert = (String)currentCert + line;
                }
                line = r.readLine();
            }
        }
        return ret;
    }
}

