/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class DSSTempUtils {
    public static File getTempFileNoCreate(String path, String prefix, String extension) {
        File subpath = DKUApp.getFile("tmp", path);
        try {
            DKUFileUtils.mkdirs((File)subpath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        File ret = new File(subpath, prefix + "-" + SecretKeyGenerator.generate(12) + "." + extension);
        return ret;
    }

    public static File getTempFileNoCreate(String path, String fileName) {
        File subpath = DKUApp.getFile("tmp", path);
        try {
            DKUFileUtils.mkdirs((File)subpath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        File ret = new File(subpath, fileName);
        return ret;
    }

    public static AutoDelete getTempFile(String path, String prefix, String extension) throws IOException {
        File subpath = DKUApp.getFile("tmp", path);
        try {
            DKUFileUtils.mkdirs((File)subpath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        while (((String)prefix).length() < 3) {
            prefix = (String)prefix + "_";
        }
        return new AutoDelete(File.createTempFile((String)prefix, "." + extension, subpath));
    }

    public static AutoDelete getTempFolder(String path, String prefix) throws IOException {
        return DSSTempUtils.getTempFolder(path, prefix, false);
    }

    public static AutoDelete getTempFolder(String path, String prefix, boolean slugifyPrefix) throws IOException {
        File subpath = DKUApp.getFile("tmp", path);
        try {
            DKUFileUtils.mkdirs((File)subpath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        if (slugifyPrefix) {
            prefix = prefix.replaceAll("[/$?*:\\\\<>\"|]", "_");
        }
        return new AutoDelete(Files.createTempDirectory(subpath.toPath(), prefix, new FileAttribute[0]).toFile());
    }

    public static AutoDelete getTempFolder(String path) throws IOException {
        return DSSTempUtils.getTempFolder(path, Long.toString(System.currentTimeMillis()));
    }

    public static File getTempFolderWithSpecificName(String path, String name) throws IOException {
        File target = DKUApp.getFile("tmp", path, name);
        try {
            DKUFileUtils.mkdirs((File)target);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        return target;
    }

    public static File getTempFileWithSpecificName(String path, String baseName, String extension) throws IOException {
        File subpath = DKUApp.getFile("tmp", path);
        try {
            DKUFileUtils.mkdirs((File)subpath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        return new File(subpath, baseName + "." + extension);
    }
}

