/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SanityCheckDAO {
    private static final RelFile dataFile = new RelFile(RelFile.global("run"), "sanity-check.json");
    private static final Logger logger = Logger.getLogger((String)"dku.sanity_check.last_result.files");

    public synchronized void writeResult(InfoMessage.InfoMessages messages) {
        try {
            NativeFS writeFS = NativeFS.from(DKUApp.getBaseFolderF()).build();
            writeFS.writeObject(dataFile, new SanityCheckFile(System.currentTimeMillis(), messages));
            logger.info((Object)"Successfully written Sanity Check result to file");
        }
        catch (IOException e) {
            logger.error((Object)"Failed to write Sanity Check result to file", (Throwable)e);
        }
    }

    public Optional<SanityCheckFile> readIfExists() {
        try {
            NativeFS readFS = NativeFS.from(DKUApp.getBaseFolderF()).build();
            if (!readFS.isFile(dataFile)) {
                logger.info((Object)"No sanity check file found to read");
                return Optional.empty();
            }
            return Optional.of(readFS.readObjectUnsafe(dataFile, SanityCheckFile.class));
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read Sanity Check result from file", (Throwable)e);
            return Optional.empty();
        }
    }

    public static class SanityCheckFile {
        public long lastRunTimestamp;
        @JsonAdapter(value=SanityCheckReportDeserializer.class)
        public InfoMessage.InfoMessages report;

        public SanityCheckFile() {
            this.report = new InfoMessage.InfoMessages();
        }

        public SanityCheckFile(long lastRunTimestamp, InfoMessage.InfoMessages report) {
            this.lastRunTimestamp = lastRunTimestamp;
            this.report = report;
        }

        private static class SanityCheckReportDeserializer
        implements JsonDeserializer<InfoMessage.InfoMessages> {
            private SanityCheckReportDeserializer() {
            }

            public InfoMessage.InfoMessages deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                if (json == null || json.isJsonNull()) {
                    return new SanityCheckInfoMessages();
                }
                SanityCheckInfoMessages report = new SanityCheckInfoMessages();
                JsonObject root = json.getAsJsonObject();
                if (root.has("messages")) {
                    JsonArray messages = root.getAsJsonArray("messages");
                    for (JsonElement elem : messages) {
                        JsonObject obj = elem.getAsJsonObject();
                        InfoMessage.Severity severity = (InfoMessage.Severity)context.deserialize(obj.get("severity"), InfoMessage.Severity.class);
                        String code = this.getString(obj, "code", "");
                        String title = this.getString(obj, "title", "");
                        String details = this.getString(obj, "details", "");
                        String extraInfoSummary = this.getString(obj, "extraInfoSummary", null);
                        String extraInfoDetails = this.getString(obj, "extraInfoDetails", null);
                        if (extraInfoSummary != null && extraInfoDetails != null) {
                            report.addMessage(new SanityCheckInfoMessages.InfoMessageWithExtraInfo(severity, code, title, details, extraInfoSummary, extraInfoDetails));
                            continue;
                        }
                        report.addMessage(new InfoMessage(severity, severity == InfoMessage.Severity.ERROR, title, code, details));
                    }
                }
                return report;
            }

            private String getString(JsonObject obj, String member, String fallback) {
                return obj.has(member) && !obj.get(member).isJsonNull() ? obj.get(member).getAsString() : fallback;
            }
        }
    }
}

