/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail.factory;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.mail.AWSMailSender;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.MicrosoftGraphMailSender;
import com.dataiku.dip.integrations.mail.SMTPSender;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailSenderFactory {
    @Autowired
    IntegrationChannelPermissionsService integrationChannelPermissionsService;

    public AbstractMailSender createMailSenderWithoutPermissionCheck(IntegrationChannel channel) {
        if (channel.configuration == null) {
            throw new IllegalArgumentException("Missing channel configuration");
        }
        if (channel.type.equals(AWSMailSender.CHANNEL_META.getType())) {
            AWSMailSender.AWSChannelConfiguration awsChannelConfiguration = (AWSMailSender.AWSChannelConfiguration)channel.configuration;
            return new AWSMailSender(awsChannelConfiguration);
        }
        if (channel.type.equals(MicrosoftGraphMailSender.CHANNEL_META.getType())) {
            MicrosoftGraphMailSender.MicrosoftGraphChannelConfiguration microsoftGraphChannelConfiguration = (MicrosoftGraphMailSender.MicrosoftGraphChannelConfiguration)channel.configuration;
            return new MicrosoftGraphMailSender(microsoftGraphChannelConfiguration);
        }
        if (channel.type.equals(SMTPSender.CHANNEL_META.getType())) {
            SMTPSender.SMTPIntegrationChannelConfiguration smtpChannelConfiguration = (SMTPSender.SMTPIntegrationChannelConfiguration)channel.configuration;
            return new SMTPSender(smtpChannelConfiguration);
        }
        throw new IllegalArgumentException("Unknown mail channel of type " + channel.type);
    }

    public AbstractMailSender createMailSender(AuthCtx user, IntegrationChannel channel) throws DKUSecurityException {
        this.integrationChannelPermissionsService.checkIntegrationChannelUse(user, channel);
        return this.createMailSenderWithoutPermissionCheck(channel);
    }
}

