/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.kernels;

import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DSSKernelBase
implements IDSSKernelBase {
    protected String id;
    protected volatile int port;
    protected IsolableProcess process = null;
    protected Integer savedReturnCode;
    protected Exception processExitException;
    protected KernelMonitorThread monitorThread;
    protected final DKUtils.ExecOutputConsumer outputConsumer;
    protected final DKUtils.SmartLogTailBuilder smartLogTailBuilder;
    private Thread shutdownHook;
    private final LinkedList<Runnable> onShutdown = new LinkedList();
    private boolean manuallyAborted;
    protected volatile boolean killed;
    private Logger logger = Logger.getLogger((String)"dku.kernels");

    public DSSKernelBase(String id) {
        this(id, new DKUtils.SmartLogTailBuilder());
    }

    public DSSKernelBase(String id, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        this.setId(id);
        this.smartLogTailBuilder = smartLogTailBuilder;
        this.outputConsumer = new DKUtils.ExecOutputConsumer().withThreadsBaseName("KNL-" + id);
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                DSSKernelBase.this.killed = true;
                if (DSSKernelBase.this.process != null) {
                    try {
                        DSSKernelBase.this.process.evilKill();
                    }
                    catch (IOException e) {
                        DSSKernelBase.this.logger.error((Object)("Could not stop kernel " + DSSKernelBase.this.id), (Throwable)e);
                    }
                }
                DSSKernelBase.this.executeOnShutdownRunnables("A shutdown runnable failed and threw an exception");
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected synchronized void tryUnregisterHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Throwable t) {
                this.logger.warn((Object)"Failed to remove shutdownHook", t);
            }
            this.shutdownHook = null;
        }
        this.executeOnShutdownRunnables("A shutdown runnable threw an exception while trying to unregister hook");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeOnShutdownRunnables(String message) {
        LinkedList<Runnable> linkedList = this.onShutdown;
        synchronized (linkedList) {
            for (Runnable runnable : this.onShutdown) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.logger.warn((Object)message, (Throwable)e);
                }
            }
            this.onShutdown.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnShutdown(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.onShutdown;
        synchronized (linkedList) {
            this.onShutdown.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killNoWaitNoException(boolean isManualAbort) {
        this.killed = true;
        IsolableProcess process = this.process;
        if (process != null) {
            this.logger.warn((Object)("Killing kernel " + this.getId()));
            try {
                process.evilKill();
            }
            catch (IOException e) {
                this.logger.warn((Object)"failed to kill kernel", (Throwable)e);
            }
            finally {
                this.tryUnregisterHook();
            }
            if (isManualAbort) {
                this.manuallyAborted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTreeNoWaitNoException(boolean isManualAbort) {
        IsolableProcess process = this.process;
        if (process != null) {
            this.logger.warn((Object)("Killing kernel " + this.getId()));
            try {
                process.evilKillTree();
            }
            catch (IOException e) {
                this.logger.warn((Object)"failed to kill kernel", (Throwable)e);
            }
            finally {
                this.tryUnregisterHook();
            }
            if (isManualAbort) {
                this.manuallyAborted = true;
            }
        }
    }

    @Override
    public void killWithoutMercy() throws IOException, InterruptedException {
        this.killWithoutMercy(false);
    }

    public void killWithoutMercy(boolean killWholeTree) throws IOException, InterruptedException {
        this.killed = true;
        IsolableProcess process = this.process;
        if (process != null) {
            this.logger.warn((Object)("Killing kernel " + this.getId()));
            try {
                if (killWholeTree) {
                    process.evilKillWholeTree();
                } else {
                    process.evilKill();
                }
            }
            finally {
                this.tryUnregisterHook();
            }
            if (this.monitorThread != null) {
                this.monitorThread.join();
                this.monitorThread = null;
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isFinished() {
        return this.savedReturnCode != null;
    }

    public int getReturnCode() {
        return this.savedReturnCode;
    }

    @Override
    public void waitForShutdownNoException(long timeout) {
        KernelMonitorThread t = this.monitorThread;
        if (t != null && t.isAlive()) {
            try {
                t.join(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.info((Object)"Interrupted while waiting for logs");
            }
        }
    }

    public void waitForShutdown() throws InterruptedException {
        KernelMonitorThread t = this.monitorThread;
        if (t != null && t.isAlive()) {
            t.join();
        }
    }

    @Override
    public SmartLogTail getLogTail() {
        this.logger.info((Object)"Getting kernel tail");
        return this.smartLogTailBuilder.get();
    }

    protected void startStandardTailers() throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
    }

    protected void startStandardTailers(FileOutputStream outputLog, FileOutputStream errorLog) throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription((OutputStream)outputLog, true));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription((OutputStream)errorLog, true));
    }

    protected void startStandardTailers(DKULogger outputLogger, DKULogger errorLogger) throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(outputLogger, Level.INFO));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(errorLogger, Level.INFO));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
    }

    @Override
    public IOException maybeRethrowAsProcessDied(IOException e) {
        IsolableProcess process = this.process;
        if (process == null) {
            this.logger.info((Object)"Process was cleaned up by monitoring thread");
            this.logger.info((Object)("Trying to enrich exception: " + String.valueOf(e) + " from kernel " + String.valueOf(this) + " retcode=" + this.savedReturnCode));
        } else {
            this.logger.info((Object)("Trying to enrich exception: " + String.valueOf(e) + " from kernel " + String.valueOf(this) + " process=" + String.valueOf(process) + " pid=" + process.getWorkingPid() + " retcode=" + this.savedReturnCode));
        }
        if (e instanceof EOFException || e.getCause() != null && e.getCause() instanceof EOFException) {
            Integer returnCode = null;
            for (int i = 0; i < 10; ++i) {
                DKUtils.unsafeSleep((long)100L);
                returnCode = this.savedReturnCode;
                if (returnCode != null) break;
            }
            if (returnCode != null && returnCode == 137) {
                return new ProcessDiedException("Process died (exit code: " + returnCode + ", killed - maybe out of memory ?)", this.getLogTail(), null, returnCode.intValue());
            }
            if (returnCode != null && returnCode != 0) {
                return new ProcessDiedException("Process died (exit code: " + returnCode + ")", this.getLogTail(), null, returnCode.intValue());
            }
            return e;
        }
        return e;
    }

    protected class KernelMonitorThread
    extends Thread {
        protected Thread toInterrupt;
        protected Closeable toClose;
        protected boolean reportComputeResourceUsage;
        protected String commandName;

        protected void onAfterProcessComplete() {
        }

        public void enableComputeResourceUsageReporting(String commandName) {
            this.reportComputeResourceUsage = true;
            this.commandName = commandName;
        }

        public synchronized void setInterruptOnFailure(Thread toInterrupt) {
            this.toInterrupt = toInterrupt;
        }

        public synchronized void setCloseOnFailure(Closeable toClose) {
            this.toClose = toClose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("KNL-" + DSSKernelBase.this.id + "-monitor-" + Thread.currentThread().getId());
            try {
                Object cru = null;
                ProcessResourceUsageMonitor resourceMonitorThread = null;
                if (this.reportComputeResourceUsage) {
                    cru = ComputeResourceUsage.forLocalProcess().reportStartNoFail();
                    resourceMonitorThread = new ProcessResourceUsageMonitor((ComputeResourceUsage)cru, this.commandName, DSSKernelBase.this.process);
                    resourceMonitorThread.start();
                }
                DSSKernelBase.this.outputConsumer.start(DSSKernelBase.this.process.getInputStream(), DSSKernelBase.this.process.getErrorStream(), DSSKernelBase.this.process.getOutputStream());
                int rv = DSSKernelBase.this.process.waitFor();
                DSSKernelBase.this.logger.info((Object)("Process done with code " + rv));
                DSSKernelBase dSSKernelBase = DSSKernelBase.this;
                synchronized (dSSKernelBase) {
                    DSSKernelBase.this.savedReturnCode = rv;
                    DSSKernelBase.this.process = null;
                }
                DSSKernelBase.this.tryUnregisterHook();
                DSSKernelBase.this.outputConsumer.finish();
                if (this.reportComputeResourceUsage) {
                    resourceMonitorThread.finish(true);
                    ((ComputeResourceUsage)cru).reportCompleteNoFail();
                }
                this.onAfterProcessComplete();
                if (rv != 0) {
                    DSSKernelBase.this.processExitException = new IOException("Kernel process return code is " + rv);
                }
            }
            catch (IOException | InterruptedException e) {
                DSSKernelBase.this.logger.error((Object)"Failure while running process", (Throwable)e);
            }
            finally {
                KernelMonitorThread kernelMonitorThread = this;
                synchronized (kernelMonitorThread) {
                    if (this.toInterrupt != null) {
                        DSSKernelBase.this.logger.info((Object)("KernelMonitorThread done: Interrupting : " + String.valueOf(this.toInterrupt)));
                        this.toInterrupt.interrupt();
                    }
                    if (this.toClose != null) {
                        DSSKernelBase.this.logger.error((Object)("KernelMonitorThread done:  Closing: " + String.valueOf(this.toClose)));
                        IOUtils.closeQuietly((Closeable)this.toClose);
                    }
                }
            }
        }
    }
}

