/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.WithMaybePid;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ProcessResourceUsageMonitor
extends Thread {
    private final ComputeResourceUsage usage;
    private final WithMaybePid wmp;
    private final long MEASUREMENT_INTERVAL = DKUApp.getParams().getLongParam("dku.cru.localProcess.measurementIntervalMS", 5000L);
    private final long UPDATE_EVERY = DKUApp.getParams().getLongParam("dku.cru.localProcess.updateEveryMeasures", 12L);
    private final long LOG_EVERY = DKUApp.getParams().getLongParam("dku.cru.localProcess.logEveryMeasures", 12L);
    private boolean aborted;
    private int HZ = 100;
    private long vmRSSPeakMB = 0L;
    private long previousTotalCPU;
    private long previousTotalCPUMeasurementTimestamp;
    private long previousMemorySumMeasurementTimestamp;
    private double sumAverageCPU = 0.0;
    private long measureCount = 0L;
    private String firstRecordedProcessStartTime = null;
    private final Object lock = new Object();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.resource");

    public ProcessResourceUsageMonitor(ComputeResourceUsage usage, String commandName, WithMaybePid wmp) {
        this.usage = usage;
        usage.localProcess = new ComputeResourceUsage.LocalProcessResourceUsageData();
        usage.localProcess.commandName = commandName;
        usage.localProcess.vmRSSTotalMBS = 0L;
        this.wmp = wmp;
        if (System.getenv("DKU_HZ") != null) {
            this.HZ = Integer.parseInt(System.getenv("DKU_HZ"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort() {
        Object object = this.lock;
        synchronized (object) {
            this.aborted = true;
            this.lock.notifyAll();
        }
    }

    public void finish(boolean grabFinalValues) throws InterruptedException {
        this.abort();
        this.join();
        if (grabFinalValues && this.usage.localProcess.pid != null && this.usage.localProcess.pid > 0) {
            this.update(this.usage.localProcess.pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("process-resource-monitor-unkpid-" + this.getId());
        try {
            Object object = this.lock;
            synchronized (object) {
                int updates = 0;
                while (!this.aborted) {
                    int pid = this.wmp.getPidIfAvailable();
                    if (pid > 0) {
                        this.setName("process-resource-monitor-" + pid + "-" + this.getId());
                        this.usage.localProcess.pid = pid;
                        this.update(pid);
                        if (updates > 0 && (long)updates % this.UPDATE_EVERY == 0L) {
                            this.usage.localProcess.cpuAverageOverPast60Seconds = this.measureCount > 0L ? this.sumAverageCPU / (double)this.measureCount : 0.0;
                            this.usage.reportUpdateNoFail();
                            this.sumAverageCPU = 0.0;
                            this.measureCount = 0L;
                        }
                        if ((long)updates % this.LOG_EVERY == 0L) {
                            logger.debug((Object)("Process stats for pid " + pid + ": " + JSON.log((Object)this.usage.localProcess)));
                        }
                        ++updates;
                    } else {
                        logger.debug((Object)"pid not available yet");
                        this.setName("process-resource-monitor-unkpid-" + this.getId());
                    }
                    this.lock.wait(this.MEASUREMENT_INTERVAL);
                }
            }
        }
        catch (InterruptedException e) {
            logger.info((Object)"Monitor thread was interrupted");
        }
    }

    private void update(int pid) {
        long now = System.currentTimeMillis();
        if (this.previousTotalCPUMeasurementTimestamp == now) {
            return;
        }
        try {
            logger.trace(() -> "Updating process stats from process " + pid);
            if (DKUtils.isOsMacOS() || DKUtils.isOsWindows()) {
                return;
            }
            File statFile = new File(String.format("/proc/%d/stat", pid));
            if (!statFile.exists()) {
                logger.warn((Object)("stat file for pid " + pid + " does not exist. Process died?"));
                return;
            }
            String stat = DKUFileUtils.readFileToStringUTF8((File)statFile);
            String[] statChunks = StringUtils.split((String)stat, (char)' ');
            String starttime = statChunks[21];
            if (this.firstRecordedProcessStartTime == null) {
                this.firstRecordedProcessStartTime = starttime;
                logger.traceV("starttime of pid %s is %s.", new Object[]{this.firstRecordedProcessStartTime, pid});
            } else if (!this.firstRecordedProcessStartTime.equals(starttime)) {
                logger.warnV("starttime changed from %s to %s for pid %s.", new Object[]{this.firstRecordedProcessStartTime, starttime, pid});
            }
            long majflt = Long.parseLong(statChunks[11]);
            long cmajflt = Long.parseLong(statChunks[12]);
            long utime = Long.parseLong(statChunks[13]);
            long stime = Long.parseLong(statChunks[14]);
            long cutime = Long.parseLong(statChunks[15]);
            long cstime = Long.parseLong(statChunks[16]);
            this.usage.localProcess.majorFaults = majflt;
            this.usage.localProcess.childrenMajorFaults = cmajflt;
            this.usage.localProcess.cpuUserTimeMS = utime * 1000L / (long)this.HZ;
            this.usage.localProcess.cpuSystemTimeMS = stime * 1000L / (long)this.HZ;
            this.usage.localProcess.cpuChildrenUserTimeMS = cutime * 1000L / (long)this.HZ;
            this.usage.localProcess.cpuChildrenSystemTimeMS = cstime * 1000L / (long)this.HZ;
            this.usage.localProcess.cpuTotalMS = (utime + stime + cutime + cstime) * 1000L / (long)this.HZ;
            File statusFile = new File(String.format("/proc/%d/status", pid));
            String status = DKUFileUtils.readFileToStringUTF8((File)statusFile);
            String[] statusLines = StringUtils.split((String)status, (String)"\n");
            long vmPeak = 0L;
            long vmSize = 0L;
            long vmRss = 0L;
            long vmHwm = 0L;
            long rssAnon = 0L;
            long vmData = 0L;
            Pattern vmPeakP = Pattern.compile("VmPeak:[^0-9]*([0-9]*)");
            Pattern vmSizeP = Pattern.compile("VmSize:\\s+([0-9]*)");
            Pattern vmRssP = Pattern.compile("VmRSS:\\s+([0-9]*)");
            Pattern vmHwmkP = Pattern.compile("VmHWM:\\s+([0-9]*)");
            Pattern rssAnonP = Pattern.compile("RssAnon:\\s+([0-9]*)");
            Pattern vmDataP = Pattern.compile("VmData:\\s+([0-9]*)");
            for (String statusLine : statusLines) {
                Matcher m = vmPeakP.matcher(statusLine);
                if (m.find()) {
                    vmPeak = Long.parseLong(m.group(1));
                }
                if ((m = vmSizeP.matcher(statusLine)).find()) {
                    vmSize = Long.parseLong(m.group(1));
                }
                if ((m = vmRssP.matcher(statusLine)).find()) {
                    vmRss = Long.parseLong(m.group(1));
                }
                if ((m = vmHwmkP.matcher(statusLine)).find()) {
                    vmHwm = Long.parseLong(m.group(1));
                }
                if ((m = rssAnonP.matcher(statusLine)).find()) {
                    rssAnon = Long.parseLong(m.group(1));
                }
                if (!(m = vmDataP.matcher(statusLine)).find()) continue;
                vmData = Long.parseLong(m.group(1));
            }
            this.usage.localProcess.vmSizePeakMB = vmPeak / 1024L;
            this.usage.localProcess.vmSizeMB = vmSize / 1024L;
            this.usage.localProcess.vmRSSMB = vmRss / 1024L;
            this.usage.localProcess.vmHWMMB = vmHwm / 1024L;
            this.usage.localProcess.vmRSSAnonMB = rssAnon / 1024L;
            this.usage.localProcess.vmDataMB = vmData / 1024L;
            if (this.usage.localProcess.vmRSSMB > this.vmRSSPeakMB) {
                this.vmRSSPeakMB = this.usage.localProcess.vmRSSMB;
            }
            this.usage.localProcess.vmRSSPeakMB = this.vmRSSPeakMB;
            long currentTotalCPU = this.usage.localProcess.cpuUserTimeMS + this.usage.localProcess.cpuSystemTimeMS;
            if (this.previousTotalCPUMeasurementTimestamp > 0L) {
                this.usage.localProcess.cpuCurrent = (double)(currentTotalCPU - this.previousTotalCPU) / (double)(now - this.previousTotalCPUMeasurementTimestamp);
            }
            this.previousTotalCPU = currentTotalCPU;
            this.previousTotalCPUMeasurementTimestamp = now;
            this.sumAverageCPU += this.usage.localProcess.cpuCurrent;
            ++this.measureCount;
            if (this.previousMemorySumMeasurementTimestamp == 0L) {
                this.previousMemorySumMeasurementTimestamp = now;
            }
            ComputeResourceUsage.LocalProcessResourceUsageData localProcessResourceUsageData = this.usage.localProcess;
            localProcessResourceUsageData.vmRSSTotalMBS = localProcessResourceUsageData.vmRSSTotalMBS + (long)((double)(vmRss / 1024L) * (double)((now - this.previousMemorySumMeasurementTimestamp) / 1000L));
            this.previousMemorySumMeasurementTimestamp = now;
            logger.trace(() -> "Update complete for pid " + pid + ": " + JSON.log((Object)this.usage.localProcess));
        }
        catch (Exception e) {
            logger.warn((Object)"Parsing failed", (Throwable)e);
        }
    }
}

