/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.rpc;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import org.apache.commons.lang.StringUtils;

public class LocalPrivilegedIntercomAPIClient
extends InternalAPIClient {
    private final String apiTicketForAuth;

    public LocalPrivilegedIntercomAPIClient(int port) {
        this(port, false, null);
    }

    public LocalPrivilegedIntercomAPIClient(int port, boolean ssl) {
        this(port, ssl, null);
    }

    public LocalPrivilegedIntercomAPIClient(int port, boolean ssl, String apiTicketForAuth) {
        super((ssl ? "https" : "http") + "://127.0.0.1:" + port, null, ssl);
        this.apiTicketForAuth = apiTicketForAuth;
    }

    @Override
    protected HttpGet newGet(String path) {
        HttpGet get = new HttpGet(this.baseURI + "/" + path);
        get.setHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret(false));
        this.setAdditionalHeadersInRequest((HttpRequestBase)get);
        return get;
    }

    @Override
    protected HttpPost newPost(String path) {
        HttpPost post = new HttpPost(this.baseURI + "/" + path);
        post.setHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret(false));
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    @Override
    protected HttpPut newPut(String path) {
        HttpPut post = new HttpPut(this.baseURI + "/" + path);
        post.setHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret(false));
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    @Override
    protected HttpDelete newDelete(String path) {
        HttpDelete post = new HttpDelete(this.baseURI + "/" + path);
        post.setHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret(false));
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    @Override
    protected void setAdditionalHeadersInRequest(HttpRequestBase req) {
        super.setAdditionalHeadersInRequest(req);
        if (StringUtils.isNotBlank((String)this.apiTicketForAuth)) {
            req.setHeader("X-DKU-APITicket", this.apiTicketForAuth);
        }
    }
}

