/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.utils.ExceptionUtils;
import java.util.List;
import java.util.Set;

public interface SanityCheckDetectorBase {
    public List<InfoMessage.MessageCode> getCodes();

    public SanityCheckInfoMessages runAnalysis(Set<String> var1);

    default public InfoMessage createFatalMessage(Throwable e) {
        return InfoMessage.fatalV((InfoMessage.MessageCode)SanityCheckCode.FATAL_DETECTOR_ANALYSIS_FAILURE, (String)"Analysis failure for %s: %s.", (Object[])new Object[]{this.getClass().getSimpleName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
    }

    public static enum SanityCheckCode implements InfoMessage.MessageCode
    {
        FATAL_DETECTOR_ANALYSIS_FAILURE("Detector analysis failure", InfoMessage.FixabilityCategory.UNKNOWN);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private SanityCheckCode(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

