/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UrlRedactionUtils {
    private static final String URL_WITH_CREDENTIALS_PATTERN_STRING = "(https?://)([^@/\\s]+)@(\\S*)";
    private static final Pattern URL_WITH_CREDENTIALS_PATTERN = Pattern.compile("(https?://)([^@/\\s]+)@(\\S*)", 2);
    private static final String GENERIC_URL_PATTERN_STRING = "\\bhttps?://\\S+?(?=[,.!?:;]*(?:[\\s><\"{}|^`]|$))";
    private static final Pattern GENERIC_URL_PATTERN = Pattern.compile("\\bhttps?://\\S+?(?=[,.!?:;]*(?:[\\s><\"{}|^`]|$))", 2);

    private UrlRedactionUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String sanitizeHttpUrls(String input, String replacement) {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        Matcher matcher = URL_WITH_CREDENTIALS_PATTERN.matcher(input);
        StringBuilder sanitized = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sanitized, matcher.group(1) + replacement + matcher.group(3));
        }
        matcher.appendTail(sanitized);
        return sanitized.toString();
    }

    public static String sanitizeHttpUrls(String input) {
        return UrlRedactionUtils.sanitizeHttpUrls(input, "***@");
    }

    public static String cleanHttpUrls(String input) {
        return UrlRedactionUtils.sanitizeHttpUrls(input, "");
    }

    public static String sanitizeUrlCredentialsAndParams(String input, Map<String, String> paramReplacementMap) {
        if (paramReplacementMap == null) {
            return UrlRedactionUtils.sanitizeHttpUrls(input);
        }
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        Matcher matcher = GENERIC_URL_PATTERN.matcher(input);
        StringBuilder sanitized = new StringBuilder();
        while (matcher.find()) {
            String urlMatched = matcher.group();
            String replacementUrl = UrlRedactionUtils.sanitizeUrlParams(urlMatched, paramReplacementMap);
            matcher.appendReplacement(sanitized, replacementUrl);
        }
        matcher.appendTail(sanitized);
        return UrlRedactionUtils.sanitizeHttpUrls(sanitized.toString());
    }

    public static String sanitizeUrlParams(String input, Map<String, String> paramReplacementMap) {
        if (StringUtils.isEmpty((String)input) || paramReplacementMap == null || paramReplacementMap.isEmpty()) {
            return input;
        }
        try {
            URIBuilder uri = new URIBuilder(input, StandardCharsets.UTF_8);
            List<NameValuePair> newParams = uri.getQueryParams().stream().map(param -> {
                String paramName = param.getName();
                if (paramReplacementMap.containsKey(param.getName())) {
                    return new BasicNameValuePair(param.getName(), (String)paramReplacementMap.get(paramName));
                }
                return param;
            }).toList();
            return uri.setParameters(newParams).build().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return input;
        }
    }
}

