/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.audit.AuditDispatcher;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailSettingsProvider;
import com.dataiku.dip.security.audit.IAuditTrailBufferService;
import com.dataiku.dip.security.audit.model.AuditTrailSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.TestFlag;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditTrailService {
    @Autowired
    private IAuditTrailBufferService bufferService;
    @Autowired
    private AuditTrailSettingsProvider settingsProvider;
    private AuditDispatcher dispatcher;
    @VisibleForTesting
    public static final TestFlag skipInit = new TestFlag();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.internal.audit.service");

    @PostConstruct
    public void init() throws Exception {
        if (skipInit.isActivated()) {
            return;
        }
        AuditTrailSettings settings = this.settingsProvider.get();
        this.dispatcher = new AuditDispatcher(settings);
    }

    public void reconfigure(AuditTrailSettings newSettings) throws IOException, DKUSecurityException {
        this.dispatcher.reconfigure(newSettings);
    }

    public void emit(AuditObj obj) {
        AuditContextBase.fillWithContext(obj.get());
        this.dispatcher.dispatch(obj);
        this.bufferService.add(obj.topic, obj.get());
    }

    public EmittableAuditObj emittable(String topic, String routingKey) {
        EmittableAuditObj ret = new EmittableAuditObj(topic);
        ret.routingKey = routingKey;
        return ret;
    }

    public EmittableAuditObj generic(String type) {
        return new EmittableAuditObj("generic").with("msgType", type);
    }

    private EmittableAuditObj authFail(String type, String auditRoutingKey) {
        return new EmittableAuditObj("authfail", auditRoutingKey).with("msgType", type);
    }

    public EmittableAuditObj failure(String type, Throwable t) {
        return new EmittableAuditObj("generic-failure").with("msgType", type).with("result", "failure").with("errorType", t.getClass().getCanonicalName()).with("errorMsg", ExceptionUtils.getMessageWithCauses((Throwable)t));
    }

    public void auditUnauthorizedException(UnauthorizedException ee, String auditRoutingKey) {
        this.authFail(ee.getType(), auditRoutingKey).with("errorType", ((Object)((Object)ee)).getClass().getSimpleName()).with("errorMsg", ExceptionUtils.getMessageWithCauses((Throwable)((Object)ee))).withAll(ee.getPayload()).emit();
    }

    public void auditNotAuthenticatedException(NotAuthenticatedException ee, String auditRoutingKey) {
        this.authFail(ee.getType(), auditRoutingKey).with("errorType", ((Object)((Object)ee)).getClass().getSimpleName()).with("errorMsg", ExceptionUtils.getMessageWithCauses((Throwable)((Object)ee))).withAll(ee.getPayload()).emit();
    }

    public class EmittableAuditObj
    extends AuditObj {
        public EmittableAuditObj(String topic) {
            super(topic);
        }

        public EmittableAuditObj(String topic, String auditRoutingKey) {
            super(topic);
            this.routingKey = auditRoutingKey;
        }

        @Override
        public EmittableAuditObj with(String key, String val) {
            super.with(key, val);
            return this;
        }

        @Override
        public EmittableAuditObj with(String key, Number val) {
            super.with(key, val);
            return this;
        }

        @Override
        public EmittableAuditObj with(String key, boolean val) {
            super.with(key, val);
            return this;
        }

        public EmittableAuditObj with(String key, JsonObject val) {
            super.with(key, (JsonElement)val);
            return this;
        }

        @Override
        public EmittableAuditObj withAll(JsonObject other) {
            super.withAll(other);
            return this;
        }

        public void emit() {
            AuditTrailService.this.emit(this);
        }
    }
}

