/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit.targets;

import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.security.audit.targets.AuditTarget;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class Log4JTarget
extends AuditTarget {
    private final DKULogger baseLogger;
    private final Log4JTargetSettings settings;

    public Log4JTarget(Log4JTargetSettings settings) {
        this.settings = settings;
        this.baseSettings = settings;
        this.baseLogger = StringUtils.isNotBlank((String)settings.loggerSuffix) ? DKULogger.getLogger((String)("dku.audit." + settings.loggerSuffix)) : DKULogger.getLogger((String)"dku.audit");
    }

    @Override
    public void handle(AuditObj auditObj) {
        JsonObject event = (JsonObject)JSON.deepCopy((Object)auditObj.get());
        event.addProperty("auditTopic", auditObj.topic);
        if (auditObj.routingKey != null) {
            event.addProperty("auditRoutingKey", auditObj.routingKey);
        }
        if (this.settings.appendTopicToLogger) {
            DKULogger topicLogger = null;
            topicLogger = StringUtils.isNotBlank((String)this.settings.loggerSuffix) ? DKULogger.getLogger((String)("dku.audit." + this.settings.loggerSuffix + "." + auditObj.topic)) : DKULogger.getLogger((String)("dku.audit." + auditObj.topic));
            topicLogger.info((Object)JSON.log((Object)event));
        } else {
            this.baseLogger.info((Object)JSON.log((Object)event));
        }
    }
}

