/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketAuthService {
    public static final String INVALID_TICKET_MESSAGE = "Ticket not given or unrecognized";
    @Autowired
    private APITicketService apiTicketService;

    public APITicketService.TicketUsage getAndUseTicket(HttpServletRequest req) throws IOException, DKUSecurityException {
        return this.apiTicketService.getAndUseTicket(req.getHeader("X-DKU-APITicket"));
    }

    public AuthCtx getTicketAuthCtx(HttpServletRequest req) throws IOException, DKUSecurityException {
        return this.apiTicketService.getTicketAuthCtx(req.getHeader("X-DKU-APITicket"));
    }

    public APITicketService.TicketUsage getAndUseMandTicket(HttpServletRequest req) throws IOException, DKUSecurityException {
        APITicketService.TicketUsage t = this.getAndUseTicket(req);
        if (t == null) {
            String origin = req.getHeader("X-DKU-CallOrigin");
            if (StringUtils.isNotBlank((String)origin) && origin.equals("notebook")) {
                throw new SecurityException("Ticket not given or unrecognized. Force reload the notebook.");
            }
            throw new SecurityException(INVALID_TICKET_MESSAGE);
        }
        return t;
    }

    public AuthCtx getMandTicketAuthCtx(HttpServletRequest req) throws IOException, DKUSecurityException {
        AuthCtx t = this.getTicketAuthCtx(req);
        if (t == null) {
            String origin = req.getHeader("X-DKU-CallOrigin");
            if (StringUtils.isNotBlank((String)origin) && origin.equals("notebook")) {
                throw new SecurityException("Ticket not given or unrecognized. Force reload the notebook.");
            }
            throw new SecurityException(INVALID_TICKET_MESSAGE);
        }
        return t;
    }

    public void failIfNoTicket(HttpServletRequest req) throws Exception {
        APITicketService.TicketUsage ticket = this.getAndUseTicket(req);
        if (ticket == null) {
            String origin = req.getHeader("X-DKU-CallOrigin");
            if (StringUtils.isNotBlank((String)origin) && origin.equals("notebook")) {
                throw new SecurityException("You are not allowed to call this API. Force reload the notebook.");
            }
            throw new SecurityException("You are not allowed to call this API");
        }
        ticket.close();
    }
}

