/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.UserRemappingRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserMapper {
    private final SSOSettings ssoSettings;

    public UserMapper(SSOSettings ssoSettings) {
        this.ssoSettings = ssoSettings;
    }

    public String remapProvidedLogin(String inputLogin) {
        if (this.ssoSettings.protocol == SSOSettings.SSOProtocol.SPNEGO && this.ssoSettings.spnegoStripRealm) {
            inputLogin = inputLogin.split("@")[0];
        }
        for (UserRemappingRule rule : this.ssoSettings.remappingRules) {
            Pattern p = Pattern.compile(rule.ruleFrom);
            Matcher m = p.matcher(inputLogin);
            if (!m.matches()) continue;
            return m.replaceFirst(rule.ruleTo);
        }
        return inputLogin;
    }
}

