/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.ldap.LdapUser;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.util.LdapUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LdapTestService {
    @Autowired
    private DkuLicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ldap");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapTestSettingsResult testSettings(LdapSettings settings) throws IOException {
        LdapTestSettingsResult result = new LdapTestSettingsResult();
        try {
            this.licenseEnforcementService.checkLdapAllowed();
            LdapUtils.ConnectionParams params = new LdapUtils.ConnectionParams(settings, this.cryptoService);
            try (LdapUtils.Connection connection = new LdapUtils.Connection(params);){
                result.serverInfo = connection.test().serverInfo;
                result.connectionOK = true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"LDAP test failed", (Throwable)e);
            result.connectionError = new SerializedError(e, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapTestUserResult getUserDetails(LdapRequest ldapRequest) throws IOException {
        LdapTestUserResult result = new LdapTestUserResult();
        try {
            logger.info((Object)("Testing LDAP user: " + ldapRequest.username));
            this.licenseEnforcementService.checkLdapAllowed();
            LdapSettings settings = ldapRequest.settings;
            LdapUtils.ConnectionParams params = new LdapUtils.ConnectionParams(settings, this.cryptoService);
            try (LdapUtils.Connection connection = new LdapUtils.Connection(params);){
                LdapUser ldapUser = connection.lookupUser(ldapRequest.username);
                result.connectionOK = true;
                if (ldapUser == null) {
                    result.recordOK = false;
                    logger.info((Object)("User " + ldapRequest.username + " not found"));
                } else {
                    result.username = ldapUser.username;
                    result.displayName = ldapUser.displayName;
                    result.email = ldapUser.email;
                    result.groups = ldapUser.groups;
                    result.distinguishedName = ldapUser.dn.getNormName();
                    result.serverInfo = connection.test().serverInfo;
                    result.recordOK = true;
                    logger.info((Object)("Found user " + result.username + ": " + JSON.log((Object)result)));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"LDAP user test failed", (Throwable)e);
            result.connectionError = new SerializedError(e, false);
        }
        return result;
    }

    public class LdapTestSettingsResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public String serverInfo;
    }

    public class LdapTestUserResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public String username;
        public String displayName;
        public Set<String> groups;
        public String email;
        public String distinguishedName;
        public String serverInfo;
        public boolean recordOK;
    }

    public static class LdapRequest {
        public LdapSettings settings = new LdapSettings();
        public String username = "";
    }
}

