/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class Journal {
    public List<RelFile> deletedFiles = new ArrayList<RelFile>();
    public List<RelFile> deletedDirectories = new ArrayList<RelFile>();
    public List<RelFile> createdDirectories = new ArrayList<RelFile>();
    private List<WrittenFile> writtenFiles = new ArrayList<WrittenFile>();
    private transient int nextId = 0;

    public boolean isEmpty() {
        return this.deletedFiles.isEmpty() && this.deletedDirectories.isEmpty() && this.createdDirectories.isEmpty() && this.writtenFiles.isEmpty();
    }

    public List<RelFile> toList() {
        ArrayList<RelFile> files = new ArrayList<RelFile>();
        files.addAll(this.deletedDirectories);
        files.addAll(this.createdDirectories);
        files.addAll(this.deletedFiles);
        for (WrittenFile wf : this.writtenFiles) {
            files.add(wf.file);
        }
        return files;
    }

    @VisibleForTesting
    public void replay(ReadWriteFS fs) throws IOException {
        for (RelFile rf : this.deletedFiles) {
            fs.deleteFile(rf);
        }
        for (RelFile rf : this.deletedDirectories) {
            fs.deleteDirectory(rf);
        }
        for (RelFile rf : this.createdDirectories) {
            fs.makeDirectory(rf);
        }
        for (WrittenFile wf : this.writtenFiles) {
            fs.writeContentUnsafeNoMkdir(wf.file, wf.content);
        }
    }

    public Iterable<WrittenFile> getWrittenFiles() {
        return this.writtenFiles;
    }

    public void addWrittenFile(WrittenFile wf) {
        wf.setTmpPath(this.nextId);
        ++this.nextId;
        this.writtenFiles.add(wf);
    }

    public static class WrittenFile {
        public final RelFile file;
        public final String md5;
        public final transient FileContent content;
        private String tmpPath;

        public WrittenFile(RelFile file, FileContent fc) throws IOException {
            this.file = file;
            this.content = fc;
            try (InputStream is = fc.getAsNewStream();){
                this.md5 = DigestUtils.md5Hex((InputStream)is);
            }
        }

        public void setTmpPath(int id) {
            int sub2Bound;
            String fullPath = this.file.getFullPath().replace("/", "_");
            String suffix = String.valueOf(id);
            if (fullPath == null) {
                this.tmpPath = suffix;
                return;
            }
            int l = fullPath.length();
            if (l <= 50) {
                this.tmpPath = fullPath + "." + suffix;
                return;
            }
            int sub1Bound = 25;
            if (Character.isHighSurrogate(fullPath.charAt(sub1Bound - 1))) {
                ++sub1Bound;
            }
            if (Character.isLowSurrogate(fullPath.charAt(sub2Bound = l - 25))) {
                --sub2Bound;
            }
            this.tmpPath = fullPath.substring(0, sub1Bound) + "." + fullPath.substring(sub2Bound, l) + "." + suffix;
        }

        public String getTmpPath() {
            return this.tmpPath;
        }
    }
}

