/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StackUtils;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SlowCodeReporter {
    private boolean logEvents = false;
    private static final int maxReportedContexts = 5000;
    private static final Set<Integer> reportedContextIds = Collections.synchronizedSet(new LinkedHashSet());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.perf.slow_code");

    public SlowCodeReporter withEventLogging() {
        this.logEvents = true;
        return this;
    }

    private synchronized boolean markAsReported(SlowCodeContext context) {
        int ctxId = context.getSimpleStackTrace().hashCode();
        if (reportedContextIds.contains(ctxId)) {
            return true;
        }
        while (reportedContextIds.size() >= 5000) {
            reportedContextIds.remove(reportedContextIds.iterator().next());
        }
        reportedContextIds.add(ctxId);
        return false;
    }

    public void report(SlowCodeContext context) {
        try {
            boolean slowCodeHandlerEnabled = DKUApp.getParams().getBoolParam("dku.perf.slowCodeHandler.enabled", true);
            if (!slowCodeHandlerEnabled) {
                return;
            }
            if (this.markAsReported(context)) {
                return;
            }
            if (this.logEvents) {
                String humanStack = StackUtils.getHumanStack(context.getStackTrace());
                logger.warn((Object)String.format("%s:%n%s", context.message, humanStack));
            }
            JsonObject payload = context.serialize();
            IReflectedEventsService.ReflectedEvent event = new IReflectedEventsService.ReflectedEvent(context.message, payload);
            IReflectedEventsService service = SpringUtils.getBean(IReflectedEventsService.class);
            service.publish(event);
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot report slow code path", (Throwable)e);
        }
    }

    public static abstract class SlowCodeContext {
        private final String message;

        public SlowCodeContext(String message) {
            this.message = message;
        }

        public abstract List<StackTraceElement> getStackTrace();

        public List<StackTraceElement> getSimpleStackTrace() {
            return this.getStackTrace();
        }

        public abstract JsonObject serialize();
    }
}

