/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.ComparisonOperator;

public class Expected {
    private final String attribute;
    private ComparisonOperator op;
    private Object[] values;

    public Expected(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attribute = attrName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.op;
    }

    public Object[] getValues() {
        return this.values == null ? null : (Object[])this.values.clone();
    }

    private Expected _withValues(Object ... values) {
        this.values = (Object[])values.clone();
        return this;
    }

    private Expected _withComparisonOperator(ComparisonOperator op) {
        this.op = op;
        return this;
    }

    public Expected eq(Object val) {
        return this._withComparisonOperator(ComparisonOperator.EQ)._withValues(val);
    }

    public Expected ne(Object val) {
        return this._withComparisonOperator(ComparisonOperator.NE)._withValues(val);
    }

    public Expected exists() {
        return this._withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public Expected notExist() {
        return this._withComparisonOperator(ComparisonOperator.NULL);
    }

    public Expected contains(Object val) {
        return this._withComparisonOperator(ComparisonOperator.CONTAINS)._withValues(val);
    }

    public Expected notContains(Object val) {
        return this._withComparisonOperator(ComparisonOperator.NOT_CONTAINS)._withValues(val);
    }

    public Expected beginsWith(String val) {
        return this._withComparisonOperator(ComparisonOperator.BEGINS_WITH)._withValues(val);
    }

    public Expected in(Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values must not be null or empty.");
        }
        return this._withComparisonOperator(ComparisonOperator.IN)._withValues(values);
    }

    public Expected between(Object low, Object hi) {
        return this._withComparisonOperator(ComparisonOperator.BETWEEN)._withValues(low, hi);
    }

    public Expected ge(Object val) {
        return this._withComparisonOperator(ComparisonOperator.GE)._withValues(val);
    }

    public Expected gt(Object val) {
        return this._withComparisonOperator(ComparisonOperator.GT)._withValues(val);
    }

    public Expected le(Object val) {
        return this._withComparisonOperator(ComparisonOperator.LE)._withValues(val);
    }

    public Expected lt(Object val) {
        return this._withComparisonOperator(ComparisonOperator.LT)._withValues(val);
    }
}

