/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.waiters;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.waiters.DescribeTableFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.waiters.TableExists;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.waiters.TableNotExists;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.FixedDelayStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.PollingStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.Waiter;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterBuilder;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonDynamoDBWaiters {
    private final AmazonDynamoDB client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonDynamoDBWaiters");

    @SdkInternalApi
    public AmazonDynamoDBWaiters(AmazonDynamoDB client) {
        this.client = client;
    }

    public Waiter<DescribeTableRequest> tableExists() {
        return new WaiterBuilder<DescribeTableRequest, DescribeTableResult>().withSdkFunction(new DescribeTableFunction(this.client)).withAcceptors(new TableExists.IsACTIVEMatcher(), new TableExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTableRequest> tableNotExists() {
        return new WaiterBuilder<DescribeTableRequest, DescribeTableResult>().withSdkFunction(new DescribeTableFunction(this.client)).withAcceptors(new TableNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

