/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AllocateHostsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class AllocateHostsRequestMarshaller
implements Marshaller<Request<AllocateHostsRequest>, AllocateHostsRequest> {
    @Override
    public Request<AllocateHostsRequest> marshall(AllocateHostsRequest allocateHostsRequest) {
        SdkInternalList allocateHostsRequestAssetIdsList;
        SdkInternalList allocateHostsRequestTagSpecificationsList;
        if (allocateHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AllocateHostsRequest> request = new DefaultRequest<AllocateHostsRequest>(allocateHostsRequest, "AmazonEC2");
        request.addParameter("Action", "AllocateHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateHostsRequest.getAutoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString(allocateHostsRequest.getAutoPlacement()));
        }
        if (allocateHostsRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(allocateHostsRequest.getAvailabilityZone()));
        }
        if (allocateHostsRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(allocateHostsRequest.getClientToken()));
        }
        if (allocateHostsRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(allocateHostsRequest.getInstanceType()));
        }
        if (allocateHostsRequest.getInstanceFamily() != null) {
            request.addParameter("InstanceFamily", StringUtils.fromString(allocateHostsRequest.getInstanceFamily()));
        }
        if (allocateHostsRequest.getQuantity() != null) {
            request.addParameter("Quantity", StringUtils.fromInteger(allocateHostsRequest.getQuantity()));
        }
        if (!(allocateHostsRequestTagSpecificationsList = (SdkInternalList)allocateHostsRequest.getTagSpecifications()).isEmpty() || !allocateHostsRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification allocateHostsRequestTagSpecificationsListValue : allocateHostsRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (allocateHostsRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(allocateHostsRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)allocateHostsRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (allocateHostsRequest.getHostRecovery() != null) {
            request.addParameter("HostRecovery", StringUtils.fromString(allocateHostsRequest.getHostRecovery()));
        }
        if (allocateHostsRequest.getOutpostArn() != null) {
            request.addParameter("OutpostArn", StringUtils.fromString(allocateHostsRequest.getOutpostArn()));
        }
        if (allocateHostsRequest.getHostMaintenance() != null) {
            request.addParameter("HostMaintenance", StringUtils.fromString(allocateHostsRequest.getHostMaintenance()));
        }
        if (!(allocateHostsRequestAssetIdsList = (SdkInternalList)allocateHostsRequest.getAssetIds()).isEmpty() || !allocateHostsRequestAssetIdsList.isAutoConstruct()) {
            int assetIdsListIndex = 1;
            for (String allocateHostsRequestAssetIdsListValue : allocateHostsRequestAssetIdsList) {
                if (allocateHostsRequestAssetIdsListValue != null) {
                    request.addParameter("AssetId." + assetIdsListIndex, StringUtils.fromString(allocateHostsRequestAssetIdsListValue));
                }
                ++assetIdsListIndex;
            }
        }
        return request;
    }
}

