/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AcceleratorCountRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiBRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbpsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CapacityReservationOptionsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateFleetRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FleetSpotCapacityRebalanceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FleetSpotMaintenanceStrategiesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.InstanceRequirementsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.MemoryGiBPerVCpuRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.MemoryMiBRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.NetworkBandwidthGbpsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.NetworkInterfaceCountRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.OnDemandOptionsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Placement;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.SpotOptionsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TotalLocalStorageGBRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VCpuCountRangeRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    @Override
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        SdkInternalList createFleetRequestTagSpecificationsList;
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        SdkInternalList createFleetRequestLaunchTemplateConfigsList;
        OnDemandOptionsRequest onDemandOptions;
        SpotOptionsRequest spotOptions;
        if (createFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFleetRequest> request = new DefaultRequest<CreateFleetRequest>(createFleetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFleetRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFleetRequest.getClientToken()));
        }
        if ((spotOptions = createFleetRequest.getSpotOptions()) != null) {
            FleetSpotCapacityRebalanceRequest capacityRebalance;
            FleetSpotMaintenanceStrategiesRequest maintenanceStrategies;
            if (spotOptions.getAllocationStrategy() != null) {
                request.addParameter("SpotOptions.AllocationStrategy", StringUtils.fromString(spotOptions.getAllocationStrategy()));
            }
            if ((maintenanceStrategies = spotOptions.getMaintenanceStrategies()) != null && (capacityRebalance = maintenanceStrategies.getCapacityRebalance()) != null) {
                if (capacityRebalance.getReplacementStrategy() != null) {
                    request.addParameter("SpotOptions.MaintenanceStrategies.CapacityRebalance.ReplacementStrategy", StringUtils.fromString(capacityRebalance.getReplacementStrategy()));
                }
                if (capacityRebalance.getTerminationDelay() != null) {
                    request.addParameter("SpotOptions.MaintenanceStrategies.CapacityRebalance.TerminationDelay", StringUtils.fromInteger(capacityRebalance.getTerminationDelay()));
                }
            }
            if (spotOptions.getInstanceInterruptionBehavior() != null) {
                request.addParameter("SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString(spotOptions.getInstanceInterruptionBehavior()));
            }
            if (spotOptions.getInstancePoolsToUseCount() != null) {
                request.addParameter("SpotOptions.InstancePoolsToUseCount", StringUtils.fromInteger(spotOptions.getInstancePoolsToUseCount()));
            }
            if (spotOptions.getSingleInstanceType() != null) {
                request.addParameter("SpotOptions.SingleInstanceType", StringUtils.fromBoolean(spotOptions.getSingleInstanceType()));
            }
            if (spotOptions.getSingleAvailabilityZone() != null) {
                request.addParameter("SpotOptions.SingleAvailabilityZone", StringUtils.fromBoolean(spotOptions.getSingleAvailabilityZone()));
            }
            if (spotOptions.getMinTargetCapacity() != null) {
                request.addParameter("SpotOptions.MinTargetCapacity", StringUtils.fromInteger(spotOptions.getMinTargetCapacity()));
            }
            if (spotOptions.getMaxTotalPrice() != null) {
                request.addParameter("SpotOptions.MaxTotalPrice", StringUtils.fromString(spotOptions.getMaxTotalPrice()));
            }
        }
        if ((onDemandOptions = createFleetRequest.getOnDemandOptions()) != null) {
            CapacityReservationOptionsRequest capacityReservationOptions;
            if (onDemandOptions.getAllocationStrategy() != null) {
                request.addParameter("OnDemandOptions.AllocationStrategy", StringUtils.fromString(onDemandOptions.getAllocationStrategy()));
            }
            if ((capacityReservationOptions = onDemandOptions.getCapacityReservationOptions()) != null && capacityReservationOptions.getUsageStrategy() != null) {
                request.addParameter("OnDemandOptions.CapacityReservationOptions.UsageStrategy", StringUtils.fromString(capacityReservationOptions.getUsageStrategy()));
            }
            if (onDemandOptions.getSingleInstanceType() != null) {
                request.addParameter("OnDemandOptions.SingleInstanceType", StringUtils.fromBoolean(onDemandOptions.getSingleInstanceType()));
            }
            if (onDemandOptions.getSingleAvailabilityZone() != null) {
                request.addParameter("OnDemandOptions.SingleAvailabilityZone", StringUtils.fromBoolean(onDemandOptions.getSingleAvailabilityZone()));
            }
            if (onDemandOptions.getMinTargetCapacity() != null) {
                request.addParameter("OnDemandOptions.MinTargetCapacity", StringUtils.fromInteger(onDemandOptions.getMinTargetCapacity()));
            }
            if (onDemandOptions.getMaxTotalPrice() != null) {
                request.addParameter("OnDemandOptions.MaxTotalPrice", StringUtils.fromString(onDemandOptions.getMaxTotalPrice()));
            }
        }
        if (createFleetRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString(createFleetRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(createFleetRequestLaunchTemplateConfigsList = (SdkInternalList)createFleetRequest.getLaunchTemplateConfigs()).isEmpty() || !createFleetRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest createFleetRequestLaunchTemplateConfigsListValue : createFleetRequestLaunchTemplateConfigsList) {
                SdkInternalList fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = createFleetRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString(launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString(launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString(launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = (SdkInternalList)createFleetRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !fleetLaunchTemplateConfigRequestOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        InstanceRequirementsRequest instanceRequirements;
                        Placement placement;
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble(fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble(fleetLaunchTemplateConfigRequestOverridesListValue.getPriority()));
                        }
                        if ((placement = fleetLaunchTemplateConfigRequestOverridesListValue.getPlacement()) != null) {
                            if (placement.getAvailabilityZone() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                            }
                            if (placement.getAffinity() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
                            }
                            if (placement.getGroupName() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                            }
                            if (placement.getPartitionNumber() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.PartitionNumber", StringUtils.fromInteger(placement.getPartitionNumber()));
                            }
                            if (placement.getHostId() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostId", StringUtils.fromString(placement.getHostId()));
                            }
                            if (placement.getTenancy() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
                            }
                            if (placement.getSpreadDomain() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.SpreadDomain", StringUtils.fromString(placement.getSpreadDomain()));
                            }
                            if (placement.getHostResourceGroupArn() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostResourceGroupArn", StringUtils.fromString(placement.getHostResourceGroupArn()));
                            }
                            if (placement.getGroupId() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupId", StringUtils.fromString(placement.getGroupId()));
                            }
                        }
                        if ((instanceRequirements = fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceRequirements()) != null) {
                            SdkInternalList instanceRequirementsRequestAllowedInstanceTypesList;
                            NetworkBandwidthGbpsRequest networkBandwidthGbps;
                            AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
                            SdkInternalList instanceRequirementsRequestAcceleratorNamesList;
                            SdkInternalList instanceRequirementsRequestAcceleratorManufacturersList;
                            AcceleratorCountRequest acceleratorCount;
                            SdkInternalList instanceRequirementsRequestAcceleratorTypesList;
                            BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
                            TotalLocalStorageGBRequest totalLocalStorageGB;
                            SdkInternalList instanceRequirementsRequestLocalStorageTypesList;
                            NetworkInterfaceCountRequest networkInterfaceCount;
                            SdkInternalList instanceRequirementsRequestInstanceGenerationsList;
                            SdkInternalList instanceRequirementsRequestExcludedInstanceTypesList;
                            MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
                            SdkInternalList instanceRequirementsRequestCpuManufacturersList;
                            MemoryMiBRequest memoryMiB;
                            VCpuCountRangeRequest vCpuCount = instanceRequirements.getVCpuCount();
                            if (vCpuCount != null) {
                                if (vCpuCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger(vCpuCount.getMin()));
                                }
                                if (vCpuCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger(vCpuCount.getMax()));
                                }
                            }
                            if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                                if (memoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger(memoryMiB.getMin()));
                                }
                                if (memoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger(memoryMiB.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsRequestCpuManufacturersList.isAutoConstruct()) {
                                int cpuManufacturersListIndex = 1;
                                for (String instanceRequirementsRequestCpuManufacturersListValue : instanceRequirementsRequestCpuManufacturersList) {
                                    if (instanceRequirementsRequestCpuManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.CpuManufacturer." + cpuManufacturersListIndex, StringUtils.fromString(instanceRequirementsRequestCpuManufacturersListValue));
                                    }
                                    ++cpuManufacturersListIndex;
                                }
                            }
                            if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                                if (memoryGiBPerVCpu.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble(memoryGiBPerVCpu.getMin()));
                                }
                                if (memoryGiBPerVCpu.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble(memoryGiBPerVCpu.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsRequestExcludedInstanceTypesList.isAutoConstruct()) {
                                int excludedInstanceTypesListIndex = 1;
                                for (Object instanceRequirementsRequestExcludedInstanceTypesListValue : instanceRequirementsRequestExcludedInstanceTypesList) {
                                    if (instanceRequirementsRequestExcludedInstanceTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.ExcludedInstanceType." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestExcludedInstanceTypesListValue));
                                    }
                                    ++excludedInstanceTypesListIndex;
                                }
                            }
                            if (!(instanceRequirementsRequestInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsRequestInstanceGenerationsList.isAutoConstruct()) {
                                Object instanceRequirementsRequestExcludedInstanceTypesListValue;
                                int instanceGenerationsListIndex = 1;
                                instanceRequirementsRequestExcludedInstanceTypesListValue = instanceRequirementsRequestInstanceGenerationsList.iterator();
                                while (instanceRequirementsRequestExcludedInstanceTypesListValue.hasNext()) {
                                    String instanceRequirementsRequestInstanceGenerationsListValue = (String)instanceRequirementsRequestExcludedInstanceTypesListValue.next();
                                    if (instanceRequirementsRequestInstanceGenerationsListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.InstanceGeneration." + instanceGenerationsListIndex, StringUtils.fromString(instanceRequirementsRequestInstanceGenerationsListValue));
                                    }
                                    ++instanceGenerationsListIndex;
                                }
                            }
                            if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger(instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger(instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getBareMetal() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString(instanceRequirements.getBareMetal()));
                            }
                            if (instanceRequirements.getBurstablePerformance() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString(instanceRequirements.getBurstablePerformance()));
                            }
                            if (instanceRequirements.getRequireHibernateSupport() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean(instanceRequirements.getRequireHibernateSupport()));
                            }
                            if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                                if (networkInterfaceCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger(networkInterfaceCount.getMin()));
                                }
                                if (networkInterfaceCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger(networkInterfaceCount.getMax()));
                                }
                            }
                            if (instanceRequirements.getLocalStorage() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString(instanceRequirements.getLocalStorage()));
                            }
                            if (!(instanceRequirementsRequestLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsRequestLocalStorageTypesList.isAutoConstruct()) {
                                int localStorageTypesListIndex = 1;
                                for (String instanceRequirementsRequestLocalStorageTypesListValue : instanceRequirementsRequestLocalStorageTypesList) {
                                    if (instanceRequirementsRequestLocalStorageTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorageType." + localStorageTypesListIndex, StringUtils.fromString(instanceRequirementsRequestLocalStorageTypesListValue));
                                    }
                                    ++localStorageTypesListIndex;
                                }
                            }
                            if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                                if (totalLocalStorageGB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble(totalLocalStorageGB.getMin()));
                                }
                                if (totalLocalStorageGB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble(totalLocalStorageGB.getMax()));
                                }
                            }
                            if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                                if (baselineEbsBandwidthMbps.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger(baselineEbsBandwidthMbps.getMin()));
                                }
                                if (baselineEbsBandwidthMbps.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger(baselineEbsBandwidthMbps.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsRequestAcceleratorTypesList.isAutoConstruct()) {
                                int acceleratorTypesListIndex = 1;
                                for (String instanceRequirementsRequestAcceleratorTypesListValue : instanceRequirementsRequestAcceleratorTypesList) {
                                    if (instanceRequirementsRequestAcceleratorTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorType." + acceleratorTypesListIndex, StringUtils.fromString(instanceRequirementsRequestAcceleratorTypesListValue));
                                    }
                                    ++acceleratorTypesListIndex;
                                }
                            }
                            if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                                if (acceleratorCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger(acceleratorCount.getMin()));
                                }
                                if (acceleratorCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger(acceleratorCount.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsRequestAcceleratorManufacturersList.isAutoConstruct()) {
                                int acceleratorManufacturersListIndex = 1;
                                for (Object instanceRequirementsRequestAcceleratorManufacturersListValue : instanceRequirementsRequestAcceleratorManufacturersList) {
                                    if (instanceRequirementsRequestAcceleratorManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorManufacturer." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorManufacturersListValue));
                                    }
                                    ++acceleratorManufacturersListIndex;
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsRequestAcceleratorNamesList.isAutoConstruct()) {
                                Object instanceRequirementsRequestAcceleratorManufacturersListValue;
                                int acceleratorNamesListIndex = 1;
                                instanceRequirementsRequestAcceleratorManufacturersListValue = instanceRequirementsRequestAcceleratorNamesList.iterator();
                                while (instanceRequirementsRequestAcceleratorManufacturersListValue.hasNext()) {
                                    String instanceRequirementsRequestAcceleratorNamesListValue = (String)instanceRequirementsRequestAcceleratorManufacturersListValue.next();
                                    if (instanceRequirementsRequestAcceleratorNamesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorName." + acceleratorNamesListIndex, StringUtils.fromString(instanceRequirementsRequestAcceleratorNamesListValue));
                                    }
                                    ++acceleratorNamesListIndex;
                                }
                            }
                            if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                                if (acceleratorTotalMemoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger(acceleratorTotalMemoryMiB.getMin()));
                                }
                                if (acceleratorTotalMemoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger(acceleratorTotalMemoryMiB.getMax()));
                                }
                            }
                            if ((networkBandwidthGbps = instanceRequirements.getNetworkBandwidthGbps()) != null) {
                                if (networkBandwidthGbps.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkBandwidthGbps.Min", StringUtils.fromDouble(networkBandwidthGbps.getMin()));
                                }
                                if (networkBandwidthGbps.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkBandwidthGbps.Max", StringUtils.fromDouble(networkBandwidthGbps.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAllowedInstanceTypesList = (SdkInternalList)instanceRequirements.getAllowedInstanceTypes()).isEmpty() || !instanceRequirementsRequestAllowedInstanceTypesList.isAutoConstruct()) {
                                int allowedInstanceTypesListIndex = 1;
                                for (String instanceRequirementsRequestAllowedInstanceTypesListValue : instanceRequirementsRequestAllowedInstanceTypesList) {
                                    if (instanceRequirementsRequestAllowedInstanceTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AllowedInstanceType." + allowedInstanceTypesListIndex, StringUtils.fromString(instanceRequirementsRequestAllowedInstanceTypesListValue));
                                    }
                                    ++allowedInstanceTypesListIndex;
                                }
                            }
                            if (instanceRequirements.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MaxSpotPriceAsPercentageOfOptimalOnDemandPrice", StringUtils.fromInteger(instanceRequirements.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice()));
                            }
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getImageId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".ImageId", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getImageId()));
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if ((targetCapacitySpecification = createFleetRequest.getTargetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.getTotalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringUtils.fromInteger(targetCapacitySpecification.getTotalTargetCapacity()));
            }
            if (targetCapacitySpecification.getOnDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringUtils.fromInteger(targetCapacitySpecification.getOnDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.getSpotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringUtils.fromInteger(targetCapacitySpecification.getSpotTargetCapacity()));
            }
            if (targetCapacitySpecification.getDefaultTargetCapacityType() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringUtils.fromString(targetCapacitySpecification.getDefaultTargetCapacityType()));
            }
            if (targetCapacitySpecification.getTargetCapacityUnitType() != null) {
                request.addParameter("TargetCapacitySpecification.TargetCapacityUnitType", StringUtils.fromString(targetCapacitySpecification.getTargetCapacityUnitType()));
            }
        }
        if (createFleetRequest.getTerminateInstancesWithExpiration() != null) {
            request.addParameter("TerminateInstancesWithExpiration", StringUtils.fromBoolean(createFleetRequest.getTerminateInstancesWithExpiration()));
        }
        if (createFleetRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(createFleetRequest.getType()));
        }
        if (createFleetRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate(createFleetRequest.getValidFrom()));
        }
        if (createFleetRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate(createFleetRequest.getValidUntil()));
        }
        if (createFleetRequest.getReplaceUnhealthyInstances() != null) {
            request.addParameter("ReplaceUnhealthyInstances", StringUtils.fromBoolean(createFleetRequest.getReplaceUnhealthyInstances()));
        }
        if (!(createFleetRequestTagSpecificationsList = (SdkInternalList)createFleetRequest.getTagSpecifications()).isEmpty() || !createFleetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFleetRequestTagSpecificationsListValue : createFleetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFleetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createFleetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFleetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createFleetRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString(createFleetRequest.getContext()));
        }
        return request;
    }
}

