/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeInstanceStatusRequestMarshaller
implements Marshaller<Request<DescribeInstanceStatusRequest>, DescribeInstanceStatusRequest> {
    @Override
    public Request<DescribeInstanceStatusRequest> marshall(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        SdkInternalList describeInstanceStatusRequestInstanceIdsList;
        if (describeInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceStatusRequest> request = new DefaultRequest<DescribeInstanceStatusRequest>(describeInstanceStatusRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInstanceStatusRequestFiltersList = (SdkInternalList)describeInstanceStatusRequest.getFilters();
        if (!describeInstanceStatusRequestFiltersList.isEmpty() || !describeInstanceStatusRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceStatusRequestFiltersListValue : describeInstanceStatusRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceStatusRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeInstanceStatusRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceStatusRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInstanceStatusRequestInstanceIdsList = (SdkInternalList)describeInstanceStatusRequest.getInstanceIds()).isEmpty() || !describeInstanceStatusRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeInstanceStatusRequestInstanceIdsListValue : describeInstanceStatusRequestInstanceIdsList) {
                if (describeInstanceStatusRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(describeInstanceStatusRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeInstanceStatusRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceStatusRequest.getMaxResults()));
        }
        if (describeInstanceStatusRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceStatusRequest.getNextToken()));
        }
        if (describeInstanceStatusRequest.getIncludeAllInstances() != null) {
            request.addParameter("IncludeAllInstances", StringUtils.fromBoolean(describeInstanceStatusRequest.getIncludeAllInstances()));
        }
        return request;
    }
}

