/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.HistoryRecord;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform.EventInformationStaxUnmarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class HistoryRecordStaxUnmarshaller
implements Unmarshaller<HistoryRecord, StaxUnmarshallerContext> {
    private static HistoryRecordStaxUnmarshaller instance;

    @Override
    public HistoryRecord unmarshall(StaxUnmarshallerContext context) throws Exception {
        HistoryRecord historyRecord = new HistoryRecord();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return historyRecord;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("eventInformation", targetDepth)) {
                    historyRecord.setEventInformation(EventInformationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventType", targetDepth)) {
                    historyRecord.setEventType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("timestamp", targetDepth)) continue;
                historyRecord.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return historyRecord;
    }

    public static HistoryRecordStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HistoryRecordStaxUnmarshaller();
        }
        return instance;
    }
}

